@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
 * @property azureKeyVaultUrl Azure Key Vault url.
 * @property credentialName Credential name.
 * @property enable Enable or disable key vault credential setting.
 * @property servicePrincipalName Service principal name to access key vault.
 */
public data class KeyVaultCredentialSettingsResponse(
    public val azureKeyVaultUrl: String? = null,
    public val credentialName: String? = null,
    public val enable: Boolean? = null,
    public val servicePrincipalName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.KeyVaultCredentialSettingsResponse): KeyVaultCredentialSettingsResponse = KeyVaultCredentialSettingsResponse(
            azureKeyVaultUrl = javaType.azureKeyVaultUrl().map({ args0 -> args0 }).orElse(null),
            credentialName = javaType.credentialName().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            servicePrincipalName = javaType.servicePrincipalName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
