@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Multi subnet ip configuration for an availability group listener.
 * @property privateIpAddress Private IP address.
 * @property sqlVirtualMachineInstance SQL virtual machine instance resource id that are enrolled into the availability group listener.
 */
public data class MultiSubnetIpConfigurationResponse(
    public val privateIpAddress: PrivateIPAddressResponse,
    public val sqlVirtualMachineInstance: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.MultiSubnetIpConfigurationResponse): MultiSubnetIpConfigurationResponse = MultiSubnetIpConfigurationResponse(
            privateIpAddress = javaType.privateIpAddress().let({ args0 ->
                com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.PrivateIPAddressResponse.Companion.toKotlin(args0)
            }),
            sqlVirtualMachineInstance = javaType.sqlVirtualMachineInstance(),
        )
    }
}
