@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Active Directory identity configuration for a resource.
 * @property principalId The Azure Active Directory principal id.
 * @property tenantId The Azure Active Directory tenant id.
 * @property type The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
 */
public data class ResourceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.ResourceIdentityResponse): ResourceIdentityResponse = ResourceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
