@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Suppress

/**
 * Set the connectivity, storage and workload settings.
 * @property additionalFeaturesServerConfigurations Additional SQL feature settings.
 * @property sqlConnectivityUpdateSettings SQL connectivity type settings.
 * @property sqlInstanceSettings SQL Instance settings.
 * @property sqlStorageUpdateSettings SQL storage update settings.
 * @property sqlWorkloadTypeUpdateSettings SQL workload type settings.
 */
public data class ServerConfigurationsManagementSettingsResponse(
    public val additionalFeaturesServerConfigurations: AdditionalFeaturesServerConfigurationsResponse? =
        null,
    public val sqlConnectivityUpdateSettings: SqlConnectivityUpdateSettingsResponse? = null,
    public val sqlInstanceSettings: SQLInstanceSettingsResponse? = null,
    public val sqlStorageUpdateSettings: SqlStorageUpdateSettingsResponse? = null,
    public val sqlWorkloadTypeUpdateSettings: SqlWorkloadTypeUpdateSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.ServerConfigurationsManagementSettingsResponse): ServerConfigurationsManagementSettingsResponse =
            ServerConfigurationsManagementSettingsResponse(
                additionalFeaturesServerConfigurations = javaType.additionalFeaturesServerConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AdditionalFeaturesServerConfigurationsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqlConnectivityUpdateSettings = javaType.sqlConnectivityUpdateSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SqlConnectivityUpdateSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqlInstanceSettings = javaType.sqlInstanceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SQLInstanceSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqlStorageUpdateSettings = javaType.sqlStorageUpdateSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SqlStorageUpdateSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqlWorkloadTypeUpdateSettings = javaType.sqlWorkloadTypeUpdateSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SqlWorkloadTypeUpdateSettingsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
