@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Set the access level and network port settings for SQL Server.
 * @property connectivityType SQL Server connectivity option.
 * @property port SQL Server port.
 */
public data class SqlConnectivityUpdateSettingsResponse(
    public val connectivityType: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.SqlConnectivityUpdateSettingsResponse): SqlConnectivityUpdateSettingsResponse = SqlConnectivityUpdateSettingsResponse(
            connectivityType = javaType.connectivityType().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
