@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Set disk storage settings for SQL Server.
 * @property diskConfigurationType Disk configuration to apply to SQL Server.
 * @property diskCount Virtual machine disk count.
 * @property startingDeviceId Device id of the first disk to be updated.
 */
public data class SqlStorageUpdateSettingsResponse(
    public val diskConfigurationType: String? = null,
    public val diskCount: Int? = null,
    public val startingDeviceId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.SqlStorageUpdateSettingsResponse): SqlStorageUpdateSettingsResponse = SqlStorageUpdateSettingsResponse(
            diskConfigurationType = javaType.diskConfigurationType().map({ args0 -> args0 }).orElse(null),
            diskCount = javaType.diskCount().map({ args0 -> args0 }).orElse(null),
            startingDeviceId = javaType.startingDeviceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
