@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Active Directory account details to operate Windows Server Failover Cluster.
 * @property clusterBootstrapAccount Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
 * @property clusterOperatorAccount Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines in the cluster.
 * @property clusterSubnetType Cluster subnet type.
 * @property domainFqdn Fully qualified name of the domain.
 * @property fileShareWitnessPath Optional path for fileshare witness.
 * @property ouPath Organizational Unit path in which the nodes and cluster will be present.
 * @property sqlServiceAccount Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
 * @property storageAccountUrl Fully qualified ARM resource id of the witness storage account.
 */
public data class WsfcDomainProfileResponse(
    public val clusterBootstrapAccount: String? = null,
    public val clusterOperatorAccount: String? = null,
    public val clusterSubnetType: String? = null,
    public val domainFqdn: String? = null,
    public val fileShareWitnessPath: String? = null,
    public val ouPath: String? = null,
    public val sqlServiceAccount: String? = null,
    public val storageAccountUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.WsfcDomainProfileResponse): WsfcDomainProfileResponse = WsfcDomainProfileResponse(
            clusterBootstrapAccount = javaType.clusterBootstrapAccount().map({ args0 -> args0 }).orElse(null),
            clusterOperatorAccount = javaType.clusterOperatorAccount().map({ args0 -> args0 }).orElse(null),
            clusterSubnetType = javaType.clusterSubnetType().map({ args0 -> args0 }).orElse(null),
            domainFqdn = javaType.domainFqdn().map({ args0 -> args0 }).orElse(null),
            fileShareWitnessPath = javaType.fileShareWitnessPath().map({ args0 -> args0 }).orElse(null),
            ouPath = javaType.ouPath().map({ args0 -> args0 }).orElse(null),
            sqlServiceAccount = javaType.sqlServiceAccount().map({ args0 -> args0 }).orElse(null),
            storageAccountUrl = javaType.storageAccountUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
