@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin

import com.pulumi.azurenative.standbypool.StandbypoolFunctions.getStandbyContainerGroupPoolPlain
import com.pulumi.azurenative.standbypool.StandbypoolFunctions.getStandbyVirtualMachinePoolPlain
import com.pulumi.azurenative.standbypool.kotlin.inputs.GetStandbyContainerGroupPoolPlainArgs
import com.pulumi.azurenative.standbypool.kotlin.inputs.GetStandbyContainerGroupPoolPlainArgsBuilder
import com.pulumi.azurenative.standbypool.kotlin.inputs.GetStandbyVirtualMachinePoolPlainArgs
import com.pulumi.azurenative.standbypool.kotlin.inputs.GetStandbyVirtualMachinePoolPlainArgsBuilder
import com.pulumi.azurenative.standbypool.kotlin.outputs.GetStandbyContainerGroupPoolResult
import com.pulumi.azurenative.standbypool.kotlin.outputs.GetStandbyVirtualMachinePoolResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.standbypool.kotlin.outputs.GetStandbyContainerGroupPoolResult.Companion.toKotlin as getStandbyContainerGroupPoolResultToKotlin
import com.pulumi.azurenative.standbypool.kotlin.outputs.GetStandbyVirtualMachinePoolResult.Companion.toKotlin as getStandbyVirtualMachinePoolResultToKotlin

public object StandbypoolFunctions {
    /**
     * Get a StandbyContainerGroupPoolResource
     * Azure REST API version: 2023-12-01-preview.
     * @param argument null
     * @return A StandbyContainerGroupPoolResource.
     */
    public suspend fun getStandbyContainerGroupPool(argument: GetStandbyContainerGroupPoolPlainArgs): GetStandbyContainerGroupPoolResult =
        getStandbyContainerGroupPoolResultToKotlin(getStandbyContainerGroupPoolPlain(argument.toJava()).await())

    /**
     * @see [getStandbyContainerGroupPool].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param standbyContainerGroupPoolName Name of the standby container group pool
     * @return A StandbyContainerGroupPoolResource.
     */
    public suspend fun getStandbyContainerGroupPool(
        resourceGroupName: String,
        standbyContainerGroupPoolName: String,
    ): GetStandbyContainerGroupPoolResult {
        val argument = GetStandbyContainerGroupPoolPlainArgs(
            resourceGroupName = resourceGroupName,
            standbyContainerGroupPoolName = standbyContainerGroupPoolName,
        )
        return getStandbyContainerGroupPoolResultToKotlin(getStandbyContainerGroupPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getStandbyContainerGroupPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;standbypool&#46;kotlin&#46;inputs&#46;GetStandbyContainerGroupPoolPlainArgs].
     * @return A StandbyContainerGroupPoolResource.
     */
    public suspend fun getStandbyContainerGroupPool(argument: suspend GetStandbyContainerGroupPoolPlainArgsBuilder.() -> Unit): GetStandbyContainerGroupPoolResult {
        val builder = GetStandbyContainerGroupPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStandbyContainerGroupPoolResultToKotlin(getStandbyContainerGroupPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a StandbyVirtualMachinePoolResource
     * Azure REST API version: 2023-12-01-preview.
     * @param argument null
     * @return A StandbyVirtualMachinePoolResource.
     */
    public suspend fun getStandbyVirtualMachinePool(argument: GetStandbyVirtualMachinePoolPlainArgs): GetStandbyVirtualMachinePoolResult =
        getStandbyVirtualMachinePoolResultToKotlin(getStandbyVirtualMachinePoolPlain(argument.toJava()).await())

    /**
     * @see [getStandbyVirtualMachinePool].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param standbyVirtualMachinePoolName Name of the standby virtual machine pool
     * @return A StandbyVirtualMachinePoolResource.
     */
    public suspend fun getStandbyVirtualMachinePool(
        resourceGroupName: String,
        standbyVirtualMachinePoolName: String,
    ): GetStandbyVirtualMachinePoolResult {
        val argument = GetStandbyVirtualMachinePoolPlainArgs(
            resourceGroupName = resourceGroupName,
            standbyVirtualMachinePoolName = standbyVirtualMachinePoolName,
        )
        return getStandbyVirtualMachinePoolResultToKotlin(getStandbyVirtualMachinePoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getStandbyVirtualMachinePool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;standbypool&#46;kotlin&#46;inputs&#46;GetStandbyVirtualMachinePoolPlainArgs].
     * @return A StandbyVirtualMachinePoolResource.
     */
    public suspend fun getStandbyVirtualMachinePool(argument: suspend GetStandbyVirtualMachinePoolPlainArgsBuilder.() -> Unit): GetStandbyVirtualMachinePoolResult {
        val builder = GetStandbyVirtualMachinePoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStandbyVirtualMachinePoolResultToKotlin(getStandbyVirtualMachinePoolPlain(builtArgument.toJava()).await())
    }
}
