@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies refill policy of the pool.
 */
public enum class RefillPolicy(
    public val javaValue: com.pulumi.azurenative.standbypool.enums.RefillPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.enums.RefillPolicy> {
    /**
     * A refill policy that standby pool is automatically refilled to maintain maxReadyCapacity.
     */
    Always(com.pulumi.azurenative.standbypool.enums.RefillPolicy.Always),
    ;

    override fun toJava(): com.pulumi.azurenative.standbypool.enums.RefillPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.enums.RefillPolicy): RefillPolicy = RefillPolicy.values().first { it.javaValue == javaType }
    }
}
