@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.ContainerGroupProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the ContainerGroupProfile.
 * @property id Specifies container group profile id of standby container groups.
 * @property revision Specifies revision of container group profile.
 */
public data class ContainerGroupProfileArgs(
    public val id: Output<String>,
    public val revision: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.ContainerGroupProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.inputs.ContainerGroupProfileArgs =
        com.pulumi.azurenative.standbypool.inputs.ContainerGroupProfileArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupProfileArgs].
 */
@PulumiTagMarker
public class ContainerGroupProfileArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var revision: Output<Double>? = null

    /**
     * @param value Specifies container group profile id of standby container groups.
     */
    @JvmName("gphmrigbwjocgxft")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies revision of container group profile.
     */
    @JvmName("bmmhruchlutjatlr")
    public suspend fun revision(`value`: Output<Double>) {
        this.revision = value
    }

    /**
     * @param value Specifies container group profile id of standby container groups.
     */
    @JvmName("cxfqbxmxlypcvabg")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies revision of container group profile.
     */
    @JvmName("fkuxsynchfqypdjp")
    public suspend fun revision(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): ContainerGroupProfileArgs = ContainerGroupProfileArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        revision = revision,
    )
}
