@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.ContainerGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details of the ContainerGroupProperties.
 * @property containerGroupProfile Specifies container group profile of standby container groups.
 * @property subnetIds Specifies subnet Ids for container group.
 */
public data class ContainerGroupPropertiesArgs(
    public val containerGroupProfile: Output<ContainerGroupProfileArgs>,
    public val subnetIds: Output<List<SubnetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.ContainerGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.inputs.ContainerGroupPropertiesArgs =
        com.pulumi.azurenative.standbypool.inputs.ContainerGroupPropertiesArgs.builder()
            .containerGroupProfile(
                containerGroupProfile.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subnetIds(
                subnetIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerGroupPropertiesArgs].
 */
@PulumiTagMarker
public class ContainerGroupPropertiesArgsBuilder internal constructor() {
    private var containerGroupProfile: Output<ContainerGroupProfileArgs>? = null

    private var subnetIds: Output<List<SubnetArgs>>? = null

    /**
     * @param value Specifies container group profile of standby container groups.
     */
    @JvmName("uiuvrrwjhxckspvj")
    public suspend fun containerGroupProfile(`value`: Output<ContainerGroupProfileArgs>) {
        this.containerGroupProfile = value
    }

    /**
     * @param value Specifies subnet Ids for container group.
     */
    @JvmName("emgfdkwatuddxuos")
    public suspend fun subnetIds(`value`: Output<List<SubnetArgs>>) {
        this.subnetIds = value
    }

    @JvmName("dfbrhljemimphmfw")
    public suspend fun subnetIds(vararg values: Output<SubnetArgs>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies subnet Ids for container group.
     */
    @JvmName("dpgirgfpocimlgtm")
    public suspend fun subnetIds(values: List<Output<SubnetArgs>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Specifies container group profile of standby container groups.
     */
    @JvmName("ksxlikltmstxpnqb")
    public suspend fun containerGroupProfile(`value`: ContainerGroupProfileArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerGroupProfile = mapped
    }

    /**
     * @param argument Specifies container group profile of standby container groups.
     */
    @JvmName("qubmbeunfcxwnkcx")
    public suspend fun containerGroupProfile(argument: suspend ContainerGroupProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerGroupProfile = mapped
    }

    /**
     * @param value Specifies subnet Ids for container group.
     */
    @JvmName("qgibsodaulvsmwfi")
    public suspend fun subnetIds(`value`: List<SubnetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param argument Specifies subnet Ids for container group.
     */
    @JvmName("fqrbcauvyumbkuai")
    public suspend fun subnetIds(argument: List<suspend SubnetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param argument Specifies subnet Ids for container group.
     */
    @JvmName("fmepwijuxiyvxktn")
    public suspend fun subnetIds(vararg argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubnetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param argument Specifies subnet Ids for container group.
     */
    @JvmName("tppykcdnmaojfrmf")
    public suspend fun subnetIds(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param values Specifies subnet Ids for container group.
     */
    @JvmName("ltglinmeleetvlmr")
    public suspend fun subnetIds(vararg values: SubnetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ContainerGroupPropertiesArgs = ContainerGroupPropertiesArgs(
        containerGroupProfile = containerGroupProfile ?: throw
            PulumiNullFieldException("containerGroupProfile"),
        subnetIds = subnetIds,
    )
}
