@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.GetStandbyVirtualMachinePoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property standbyVirtualMachinePoolName Name of the standby virtual machine pool
 */
public data class GetStandbyVirtualMachinePoolPlainArgs(
    public val resourceGroupName: String,
    public val standbyVirtualMachinePoolName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.GetStandbyVirtualMachinePoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.inputs.GetStandbyVirtualMachinePoolPlainArgs =
        com.pulumi.azurenative.standbypool.inputs.GetStandbyVirtualMachinePoolPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .standbyVirtualMachinePoolName(standbyVirtualMachinePoolName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStandbyVirtualMachinePoolPlainArgs].
 */
@PulumiTagMarker
public class GetStandbyVirtualMachinePoolPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var standbyVirtualMachinePoolName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xmasskrkgasebymu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the standby virtual machine pool
     */
    @JvmName("jcwhdeiwmyljuqcg")
    public suspend fun standbyVirtualMachinePoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.standbyVirtualMachinePoolName = mapped
    }

    internal fun build(): GetStandbyVirtualMachinePoolPlainArgs =
        GetStandbyVirtualMachinePoolPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            standbyVirtualMachinePoolName = standbyVirtualMachinePoolName ?: throw
                PulumiNullFieldException("standbyVirtualMachinePoolName"),
        )
}
