@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.StandbyContainerGroupPoolElasticityProfileArgs.builder
import com.pulumi.azurenative.standbypool.kotlin.enums.RefillPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the elasticity profile of the standby container group pools.
 * @property maxReadyCapacity Specifies maximum number of standby container groups in the standby pool.
 * @property refillPolicy Specifies refill policy of the pool.
 */
public data class StandbyContainerGroupPoolElasticityProfileArgs(
    public val maxReadyCapacity: Output<Double>,
    public val refillPolicy: Output<Either<String, RefillPolicy>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.StandbyContainerGroupPoolElasticityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.standbypool.inputs.StandbyContainerGroupPoolElasticityProfileArgs =
        com.pulumi.azurenative.standbypool.inputs.StandbyContainerGroupPoolElasticityProfileArgs.builder()
            .maxReadyCapacity(maxReadyCapacity.applyValue({ args0 -> args0 }))
            .refillPolicy(
                refillPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [StandbyContainerGroupPoolElasticityProfileArgs].
 */
@PulumiTagMarker
public class StandbyContainerGroupPoolElasticityProfileArgsBuilder internal constructor() {
    private var maxReadyCapacity: Output<Double>? = null

    private var refillPolicy: Output<Either<String, RefillPolicy>>? = null

    /**
     * @param value Specifies maximum number of standby container groups in the standby pool.
     */
    @JvmName("rtcmabdjrqvggifp")
    public suspend fun maxReadyCapacity(`value`: Output<Double>) {
        this.maxReadyCapacity = value
    }

    /**
     * @param value Specifies refill policy of the pool.
     */
    @JvmName("ptdxdgjqjbsimvsn")
    public suspend fun refillPolicy(`value`: Output<Either<String, RefillPolicy>>) {
        this.refillPolicy = value
    }

    /**
     * @param value Specifies maximum number of standby container groups in the standby pool.
     */
    @JvmName("biwllykvwnakgouy")
    public suspend fun maxReadyCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxReadyCapacity = mapped
    }

    /**
     * @param value Specifies refill policy of the pool.
     */
    @JvmName("fxsqaqfhatqkkddi")
    public suspend fun refillPolicy(`value`: Either<String, RefillPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refillPolicy = mapped
    }

    /**
     * @param value Specifies refill policy of the pool.
     */
    @JvmName("tchisbphooklteup")
    public fun refillPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RefillPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refillPolicy = mapped
    }

    /**
     * @param value Specifies refill policy of the pool.
     */
    @JvmName("ollqhiaaaqlesynt")
    public fun refillPolicy(`value`: RefillPolicy) {
        val toBeMapped = Either.ofRight<String, RefillPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refillPolicy = mapped
    }

    internal fun build(): StandbyContainerGroupPoolElasticityProfileArgs =
        StandbyContainerGroupPoolElasticityProfileArgs(
            maxReadyCapacity = maxReadyCapacity ?: throw PulumiNullFieldException("maxReadyCapacity"),
            refillPolicy = refillPolicy,
        )
}
