@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Details of the ContainerGroupProfile.
 * @property id Specifies container group profile id of standby container groups.
 * @property revision Specifies revision of container group profile.
 */
public data class ContainerGroupProfileResponse(
    public val id: String,
    public val revision: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.outputs.ContainerGroupProfileResponse): ContainerGroupProfileResponse = ContainerGroupProfileResponse(
            id = javaType.id(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
