@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of the ContainerGroupProperties.
 * @property containerGroupProfile Specifies container group profile of standby container groups.
 * @property subnetIds Specifies subnet Ids for container group.
 */
public data class ContainerGroupPropertiesResponse(
    public val containerGroupProfile: ContainerGroupProfileResponse,
    public val subnetIds: List<SubnetResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.outputs.ContainerGroupPropertiesResponse): ContainerGroupPropertiesResponse = ContainerGroupPropertiesResponse(
            containerGroupProfile = javaType.containerGroupProfile().let({ args0 ->
                com.pulumi.azurenative.standbypool.kotlin.outputs.ContainerGroupProfileResponse.Companion.toKotlin(args0)
            }),
            subnetIds = javaType.subnetIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.standbypool.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
