@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A StandbyVirtualMachinePoolResource.
 * @property attachedVirtualMachineScaleSetId Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to.
 * @property elasticityProfile Specifies the elasticity profile of the standby virtual machine pools.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachineState Specifies the desired state of virtual machines in the pool.
 */
public data class GetStandbyVirtualMachinePoolResult(
    public val attachedVirtualMachineScaleSetId: String? = null,
    public val elasticityProfile: StandbyVirtualMachinePoolElasticityProfileResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachineState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.outputs.GetStandbyVirtualMachinePoolResult): GetStandbyVirtualMachinePoolResult = GetStandbyVirtualMachinePoolResult(
            attachedVirtualMachineScaleSetId = javaType.attachedVirtualMachineScaleSetId().map({ args0 ->
                args0
            }).orElse(null),
            elasticityProfile = javaType.elasticityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.standbypool.kotlin.outputs.StandbyVirtualMachinePoolElasticityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.standbypool.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachineState = javaType.virtualMachineState(),
        )
    }
}
