@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the elasticity profile of the standby container group pools.
 * @property maxReadyCapacity Specifies maximum number of standby container groups in the standby pool.
 * @property refillPolicy Specifies refill policy of the pool.
 */
public data class StandbyContainerGroupPoolElasticityProfileResponse(
    public val maxReadyCapacity: Double,
    public val refillPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.outputs.StandbyContainerGroupPoolElasticityProfileResponse): StandbyContainerGroupPoolElasticityProfileResponse =
            StandbyContainerGroupPoolElasticityProfileResponse(
                maxReadyCapacity = javaType.maxReadyCapacity(),
                refillPolicy = javaType.refillPolicy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
