@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Details of the elasticity profile.
 * @property maxReadyCapacity Specifies the maximum number of virtual machines in the standby virtual machine pool.
 */
public data class StandbyVirtualMachinePoolElasticityProfileResponse(
    public val maxReadyCapacity: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.standbypool.outputs.StandbyVirtualMachinePoolElasticityProfileResponse): StandbyVirtualMachinePoolElasticityProfileResponse =
            StandbyVirtualMachinePoolElasticityProfileResponse(
                maxReadyCapacity = javaType.maxReadyCapacity(),
            )
    }
}
