@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobContainerArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.PublicAccess
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageWithVersioningArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageWithVersioningArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties of the blob container, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### PutContainerWithDefaultEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         DefaultEncryptionScope = "encryptionscope185",
 *         DenyEncryptionScopeOverride = true,
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:                 pulumi.String("sto328"),
 * 			ContainerName:               pulumi.String("container6185"),
 * 			DefaultEncryptionScope:      pulumi.String("encryptionscope185"),
 * 			DenyEncryptionScopeOverride: pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .defaultEncryptionScope("encryptionscope185")
 *             .denyEncryptionScopeOverride(true)
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### PutContainerWithObjectLevelWorm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         ImmutableStorageWithVersioning = new AzureNative.Storage.Inputs.ImmutableStorageWithVersioningArgs
 *         {
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:   pulumi.String("sto328"),
 * 			ContainerName: pulumi.String("container6185"),
 * 			ImmutableStorageWithVersioning: &storage.ImmutableStorageWithVersioningArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .immutableStorageWithVersioning(ImmutableStorageWithVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### PutContainers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ContainerName:     pulumi.String("container6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainer container6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property containerName The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 * @property defaultEncryptionScope Default the container to use specified encryption scope for all writes.
 * @property denyEncryptionScopeOverride Block override of encryption scope from the container default.
 * @property enableNfsV3AllSquash Enable NFSv3 all squash on blob container.
 * @property enableNfsV3RootSquash Enable NFSv3 root squash on blob container.
 * @property immutableStorageWithVersioning The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
 * @property metadata A name-value pair to associate with the container as metadata.
 * @property publicAccess Specifies whether data in the container may be accessed publicly and the level of access.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class BlobContainerArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val defaultEncryptionScope: Output<String>? = null,
    public val denyEncryptionScopeOverride: Output<Boolean>? = null,
    public val enableNfsV3AllSquash: Output<Boolean>? = null,
    public val enableNfsV3RootSquash: Output<Boolean>? = null,
    public val immutableStorageWithVersioning: Output<ImmutableStorageWithVersioningArgs>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val publicAccess: Output<PublicAccess>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobContainerArgs =
        com.pulumi.azurenative.storage.BlobContainerArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .defaultEncryptionScope(defaultEncryptionScope?.applyValue({ args0 -> args0 }))
            .denyEncryptionScopeOverride(denyEncryptionScopeOverride?.applyValue({ args0 -> args0 }))
            .enableNfsV3AllSquash(enableNfsV3AllSquash?.applyValue({ args0 -> args0 }))
            .enableNfsV3RootSquash(enableNfsV3RootSquash?.applyValue({ args0 -> args0 }))
            .immutableStorageWithVersioning(
                immutableStorageWithVersioning?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .publicAccess(publicAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobContainerArgs].
 */
@PulumiTagMarker
public class BlobContainerArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var defaultEncryptionScope: Output<String>? = null

    private var denyEncryptionScopeOverride: Output<Boolean>? = null

    private var enableNfsV3AllSquash: Output<Boolean>? = null

    private var enableNfsV3RootSquash: Output<Boolean>? = null

    private var immutableStorageWithVersioning: Output<ImmutableStorageWithVersioningArgs>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var publicAccess: Output<PublicAccess>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("jnocdvqnbltfolfe")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("wofhycxsxfhcfdxv")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Default the container to use specified encryption scope for all writes.
     */
    @JvmName("mwxowyevsklcvjqr")
    public suspend fun defaultEncryptionScope(`value`: Output<String>) {
        this.defaultEncryptionScope = value
    }

    /**
     * @param value Block override of encryption scope from the container default.
     */
    @JvmName("oqwrsfmnwvqodtnq")
    public suspend fun denyEncryptionScopeOverride(`value`: Output<Boolean>) {
        this.denyEncryptionScopeOverride = value
    }

    /**
     * @param value Enable NFSv3 all squash on blob container.
     */
    @JvmName("mfgrdppwcbsfimyj")
    public suspend fun enableNfsV3AllSquash(`value`: Output<Boolean>) {
        this.enableNfsV3AllSquash = value
    }

    /**
     * @param value Enable NFSv3 root squash on blob container.
     */
    @JvmName("cuilrwijguhhuydy")
    public suspend fun enableNfsV3RootSquash(`value`: Output<Boolean>) {
        this.enableNfsV3RootSquash = value
    }

    /**
     * @param value The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
     */
    @JvmName("exgjjwjyitcrtpbq")
    public suspend fun immutableStorageWithVersioning(`value`: Output<ImmutableStorageWithVersioningArgs>) {
        this.immutableStorageWithVersioning = value
    }

    /**
     * @param value A name-value pair to associate with the container as metadata.
     */
    @JvmName("wlncewwoeatyjqxb")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Specifies whether data in the container may be accessed publicly and the level of access.
     */
    @JvmName("ypawmjmdecampylq")
    public suspend fun publicAccess(`value`: Output<PublicAccess>) {
        this.publicAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qahpjhdnvesktddl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pxnasjaxdukwvwdh")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("lliviuxwdyayxsuy")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Default the container to use specified encryption scope for all writes.
     */
    @JvmName("qurrsljlujtktbgu")
    public suspend fun defaultEncryptionScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEncryptionScope = mapped
    }

    /**
     * @param value Block override of encryption scope from the container default.
     */
    @JvmName("talrprfactovhcpw")
    public suspend fun denyEncryptionScopeOverride(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denyEncryptionScopeOverride = mapped
    }

    /**
     * @param value Enable NFSv3 all squash on blob container.
     */
    @JvmName("ugqmgypgajdvqwox")
    public suspend fun enableNfsV3AllSquash(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNfsV3AllSquash = mapped
    }

    /**
     * @param value Enable NFSv3 root squash on blob container.
     */
    @JvmName("lrarqfhenvavosru")
    public suspend fun enableNfsV3RootSquash(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNfsV3RootSquash = mapped
    }

    /**
     * @param value The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
     */
    @JvmName("kcfuqkrluayunxhy")
    public suspend fun immutableStorageWithVersioning(`value`: ImmutableStorageWithVersioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param argument The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
     */
    @JvmName("gwtbicixonsftywa")
    public suspend fun immutableStorageWithVersioning(argument: suspend ImmutableStorageWithVersioningArgsBuilder.() -> Unit) {
        val toBeMapped = ImmutableStorageWithVersioningArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param value A name-value pair to associate with the container as metadata.
     */
    @JvmName("qqkgwmhlikmhmgvq")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values A name-value pair to associate with the container as metadata.
     */
    @JvmName("vmlcgcmikyrrwsgo")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Specifies whether data in the container may be accessed publicly and the level of access.
     */
    @JvmName("yghriixnoxvwpqui")
    public suspend fun publicAccess(`value`: PublicAccess?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kfpfcoahrmfkhbrf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): BlobContainerArgs = BlobContainerArgs(
        accountName = accountName,
        containerName = containerName,
        defaultEncryptionScope = defaultEncryptionScope,
        denyEncryptionScopeOverride = denyEncryptionScopeOverride,
        enableNfsV3AllSquash = enableNfsV3AllSquash,
        enableNfsV3RootSquash = enableNfsV3RootSquash,
        immutableStorageWithVersioning = immutableStorageWithVersioning,
        metadata = metadata,
        publicAccess = publicAccess,
        resourceGroupName = resourceGroupName,
    )
}
