@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BlobContainerImmutabilityPolicy].
 */
@PulumiTagMarker
public class BlobContainerImmutabilityPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobContainerImmutabilityPolicyArgs = BlobContainerImmutabilityPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobContainerImmutabilityPolicyArgsBuilder.() -> Unit) {
        val builder = BlobContainerImmutabilityPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobContainerImmutabilityPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlobContainerImmutabilityPolicy(builtJavaResource)
    }
}

/**
 * The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2019-04-01, 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### CreateOrUpdateImmutabilityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerImmutabilityPolicy = new AzureNative.Storage.BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", new()
 *     {
 *         AccountName = "sto7069",
 *         AllowProtectedAppendWrites = true,
 *         ContainerName = "container6397",
 *         ImmutabilityPeriodSinceCreationInDays = 3,
 *         ImmutabilityPolicyName = "default",
 *         ResourceGroupName = "res1782",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainerImmutabilityPolicy(ctx, "blobContainerImmutabilityPolicy", &storage.BlobContainerImmutabilityPolicyArgs{
 * 			AccountName:                           pulumi.String("sto7069"),
 * 			AllowProtectedAppendWrites:            pulumi.Bool(true),
 * 			ContainerName:                         pulumi.String("container6397"),
 * 			ImmutabilityPeriodSinceCreationInDays: pulumi.Int(3),
 * 			ImmutabilityPolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:                     pulumi.String("res1782"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerImmutabilityPolicy = new BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", BlobContainerImmutabilityPolicyArgs.builder()
 *             .accountName("sto7069")
 *             .allowProtectedAppendWrites(true)
 *             .containerName("container6397")
 *             .immutabilityPeriodSinceCreationInDays(3)
 *             .immutabilityPolicyName("default")
 *             .resourceGroupName("res1782")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdateImmutabilityPolicyWithAllowProtectedAppendWritesAll
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerImmutabilityPolicy = new AzureNative.Storage.BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", new()
 *     {
 *         AccountName = "sto7069",
 *         AllowProtectedAppendWritesAll = true,
 *         ContainerName = "container6397",
 *         ImmutabilityPeriodSinceCreationInDays = 3,
 *         ImmutabilityPolicyName = "default",
 *         ResourceGroupName = "res1782",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainerImmutabilityPolicy(ctx, "blobContainerImmutabilityPolicy", &storage.BlobContainerImmutabilityPolicyArgs{
 * 			AccountName:                           pulumi.String("sto7069"),
 * 			AllowProtectedAppendWritesAll:         pulumi.Bool(true),
 * 			ContainerName:                         pulumi.String("container6397"),
 * 			ImmutabilityPeriodSinceCreationInDays: pulumi.Int(3),
 * 			ImmutabilityPolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:                     pulumi.String("res1782"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy;
 * import com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerImmutabilityPolicy = new BlobContainerImmutabilityPolicy("blobContainerImmutabilityPolicy", BlobContainerImmutabilityPolicyArgs.builder()
 *             .accountName("sto7069")
 *             .allowProtectedAppendWritesAll(true)
 *             .containerName("container6397")
 *             .immutabilityPeriodSinceCreationInDays(3)
 *             .immutabilityPolicyName("default")
 *             .resourceGroupName("res1782")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainerImmutabilityPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/immutabilityPolicies/{immutabilityPolicyName}
 * ```
 */
public class BlobContainerImmutabilityPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy,
) : KotlinCustomResource(javaResource, BlobContainerImmutabilityPolicyMapper) {
    /**
     * This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API.
     */
    public val allowProtectedAppendWrites: Output<Boolean>?
        get() = javaResource.allowProtectedAppendWrites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and 'allowProtectedAppendWritesAll' properties are mutually exclusive.
     */
    public val allowProtectedAppendWritesAll: Output<Boolean>?
        get() = javaResource.allowProtectedAppendWritesAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The immutability period for the blobs in the container since the policy creation, in days.
     */
    public val immutabilityPeriodSinceCreationInDays: Output<Int>?
        get() = javaResource.immutabilityPeriodSinceCreationInDays().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BlobContainerImmutabilityPolicyMapper :
    ResourceMapper<BlobContainerImmutabilityPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BlobContainerImmutabilityPolicy =
        BlobContainerImmutabilityPolicy(
            javaResource as
                com.pulumi.azurenative.storage.BlobContainerImmutabilityPolicy,
        )
}

/**
 * @see [BlobContainerImmutabilityPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobContainerImmutabilityPolicy].
 */
public suspend fun blobContainerImmutabilityPolicy(
    name: String,
    block: suspend BlobContainerImmutabilityPolicyResourceBuilder.() -> Unit,
): BlobContainerImmutabilityPolicy {
    val builder = BlobContainerImmutabilityPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobContainerImmutabilityPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobContainerImmutabilityPolicy(name: String): BlobContainerImmutabilityPolicy {
    val builder = BlobContainerImmutabilityPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
