@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [BlobContainerLegalHold].
 */
@PulumiTagMarker
public class BlobContainerLegalHoldResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobContainerLegalHoldArgs = BlobContainerLegalHoldArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobContainerLegalHoldArgsBuilder.() -> Unit) {
        val builder = BlobContainerLegalHoldArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobContainerLegalHold {
        val builtJavaResource =
            com.pulumi.azurenative.storage.BlobContainerLegalHold(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlobContainerLegalHold(builtJavaResource)
    }
}

/**
 * .
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainerLegalHold myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/legalHold
 * ```
 */
public class BlobContainerLegalHold internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.BlobContainerLegalHold,
) : KotlinCustomResource(javaResource, BlobContainerLegalHoldMapper) {
    /**
     * Name of the Storage Account.
     */
    public val accountName: Output<String>?
        get() = javaResource.accountName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
     */
    public val allowProtectedAppendWritesAll: Output<Boolean>?
        get() = javaResource.allowProtectedAppendWritesAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Blob Container.
     */
    public val containerName: Output<String>?
        get() = javaResource.containerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource group that contains the storage account.
     */
    public val resourceGroupName: Output<String>?
        get() = javaResource.resourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
     */
    public val tags: Output<List<String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object BlobContainerLegalHoldMapper : ResourceMapper<BlobContainerLegalHold> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.BlobContainerLegalHold::class == javaResource::class

    override fun map(javaResource: Resource): BlobContainerLegalHold =
        BlobContainerLegalHold(javaResource as com.pulumi.azurenative.storage.BlobContainerLegalHold)
}

/**
 * @see [BlobContainerLegalHold].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobContainerLegalHold].
 */
public suspend fun blobContainerLegalHold(
    name: String,
    block: suspend BlobContainerLegalHoldResourceBuilder.() -> Unit,
): BlobContainerLegalHold {
    val builder = BlobContainerLegalHoldResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobContainerLegalHold].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobContainerLegalHold(name: String): BlobContainerLegalHold {
    val builder = BlobContainerLegalHoldResourceBuilder()
    builder.name(name)
    return builder.build()
}
