@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.BlobInventoryPolicySchemaArgs
import com.pulumi.azurenative.storage.kotlin.inputs.BlobInventoryPolicySchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage account blob inventory policy.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### StorageAccountSetBlobInventoryPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = AzureNative.Storage.Format.Csv,
 *                         ObjectType = AzureNative.Storage.ObjectType.Blob,
 *                         Schedule = AzureNative.Storage.Schedule.Daily,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "Metadata",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = AzureNative.Storage.Format.Parquet,
 *                         ObjectType = AzureNative.Storage.ObjectType.Container,
 *                         Schedule = AzureNative.Storage.Schedule.Weekly,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = AzureNative.Storage.InventoryRuleType.Inventory,
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * 			AccountName:             pulumi.String("sto9699"),
 * 			BlobInventoryPolicyName: pulumi.String("default"),
 * 			Policy: &storage.BlobInventoryPolicySchemaArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Rules: storage.BlobInventoryPolicyRuleArray{
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Filters: &storage.BlobInventoryPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 									pulumi.String("appendBlob"),
 * 									pulumi.String("pageBlob"),
 * 								},
 * 								ExcludePrefix: pulumi.StringArray{
 * 									pulumi.String("excludeprefix1"),
 * 									pulumi.String("excludeprefix2"),
 * 								},
 * 								IncludeBlobVersions: pulumi.Bool(true),
 * 								IncludeSnapshots:    pulumi.Bool(true),
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("inventoryprefix1"),
 * 									pulumi.String("inventoryprefix2"),
 * 								},
 * 							},
 * 							Format:     pulumi.String(storage.FormatCsv),
 * 							ObjectType: pulumi.String(storage.ObjectTypeBlob),
 * 							Schedule:   pulumi.String(storage.ScheduleDaily),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Creation-Time"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Content-Length"),
 * 								pulumi.String("Content-MD5"),
 * 								pulumi.String("BlobType"),
 * 								pulumi.String("AccessTier"),
 * 								pulumi.String("AccessTierChangeTime"),
 * 								pulumi.String("Snapshot"),
 * 								pulumi.String("VersionId"),
 * 								pulumi.String("IsCurrentVersion"),
 * 								pulumi.String("Metadata"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container1"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule1"),
 * 					},
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Format:     pulumi.String(storage.FormatParquet),
 * 							ObjectType: pulumi.String(storage.ObjectTypeContainer),
 * 							Schedule:   pulumi.String(storage.ScheduleWeekly),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Metadata"),
 * 								pulumi.String("LeaseStatus"),
 * 								pulumi.String("LeaseState"),
 * 								pulumi.String("LeaseDuration"),
 * 								pulumi.String("PublicAccess"),
 * 								pulumi.String("HasImmutabilityPolicy"),
 * 								pulumi.String("HasLegalHold"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container2"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule2"),
 * 					},
 * 				},
 * 				Type: pulumi.String(storage.InventoryRuleTypeInventory),
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(BlobInventoryPolicySchemaArgs.builder()
 *                 .enabled(true)
 *                 .rules(
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .filters(BlobInventoryPolicyFilterArgs.builder()
 *                                 .blobTypes(
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob")
 *                                 .excludePrefix(
 *                                     "excludeprefix1",
 *                                     "excludeprefix2")
 *                                 .includeBlobVersions(true)
 *                                 .includeSnapshots(true)
 *                                 .prefixMatch(
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                                 .build())
 *                             .format("Csv")
 *                             .objectType("Blob")
 *                             .schedule("Daily")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "Metadata")
 *                             .build())
 *                         .destination("container1")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule1")
 *                         .build(),
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .format("Parquet")
 *                             .objectType("Container")
 *                             .schedule("Weekly")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold")
 *                             .build())
 *                         .destination("container2")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule2")
 *                         .build())
 *                 .type("Inventory")
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForHnsAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeDeleted = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = AzureNative.Storage.Format.Csv,
 *                         ObjectType = AzureNative.Storage.ObjectType.Blob,
 *                         Schedule = AzureNative.Storage.Schedule.Daily,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "ContentType",
 *                             "ContentEncoding",
 *                             "ContentLanguage",
 *                             "ContentCRC64",
 *                             "CacheControl",
 *                             "Metadata",
 *                             "DeletionId",
 *                             "Deleted",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = AzureNative.Storage.Format.Parquet,
 *                         ObjectType = AzureNative.Storage.ObjectType.Container,
 *                         Schedule = AzureNative.Storage.Schedule.Weekly,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                             "Etag",
 *                             "DefaultEncryptionScope",
 *                             "DenyEncryptionScopeOverride",
 *                             "ImmutableStorageWithVersioningEnabled",
 *                             "Deleted",
 *                             "Version",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = AzureNative.Storage.InventoryRuleType.Inventory,
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * 			AccountName:             pulumi.String("sto9699"),
 * 			BlobInventoryPolicyName: pulumi.String("default"),
 * 			Policy: &storage.BlobInventoryPolicySchemaArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Rules: storage.BlobInventoryPolicyRuleArray{
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Filters: &storage.BlobInventoryPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 									pulumi.String("appendBlob"),
 * 									pulumi.String("pageBlob"),
 * 								},
 * 								ExcludePrefix: pulumi.StringArray{
 * 									pulumi.String("excludeprefix1"),
 * 									pulumi.String("excludeprefix2"),
 * 								},
 * 								IncludeBlobVersions: pulumi.Bool(true),
 * 								IncludeDeleted:      pulumi.Bool(true),
 * 								IncludeSnapshots:    pulumi.Bool(true),
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("inventoryprefix1"),
 * 									pulumi.String("inventoryprefix2"),
 * 								},
 * 							},
 * 							Format:     pulumi.String(storage.FormatCsv),
 * 							ObjectType: pulumi.String(storage.ObjectTypeBlob),
 * 							Schedule:   pulumi.String(storage.ScheduleDaily),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Creation-Time"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Content-Length"),
 * 								pulumi.String("Content-MD5"),
 * 								pulumi.String("BlobType"),
 * 								pulumi.String("AccessTier"),
 * 								pulumi.String("AccessTierChangeTime"),
 * 								pulumi.String("Snapshot"),
 * 								pulumi.String("VersionId"),
 * 								pulumi.String("IsCurrentVersion"),
 * 								pulumi.String("ContentType"),
 * 								pulumi.String("ContentEncoding"),
 * 								pulumi.String("ContentLanguage"),
 * 								pulumi.String("ContentCRC64"),
 * 								pulumi.String("CacheControl"),
 * 								pulumi.String("Metadata"),
 * 								pulumi.String("DeletionId"),
 * 								pulumi.String("Deleted"),
 * 								pulumi.String("DeletedTime"),
 * 								pulumi.String("RemainingRetentionDays"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container1"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule1"),
 * 					},
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Format:     pulumi.String(storage.FormatParquet),
 * 							ObjectType: pulumi.String(storage.ObjectTypeContainer),
 * 							Schedule:   pulumi.String(storage.ScheduleWeekly),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Metadata"),
 * 								pulumi.String("LeaseStatus"),
 * 								pulumi.String("LeaseState"),
 * 								pulumi.String("LeaseDuration"),
 * 								pulumi.String("PublicAccess"),
 * 								pulumi.String("HasImmutabilityPolicy"),
 * 								pulumi.String("HasLegalHold"),
 * 								pulumi.String("Etag"),
 * 								pulumi.String("DefaultEncryptionScope"),
 * 								pulumi.String("DenyEncryptionScopeOverride"),
 * 								pulumi.String("ImmutableStorageWithVersioningEnabled"),
 * 								pulumi.String("Deleted"),
 * 								pulumi.String("Version"),
 * 								pulumi.String("DeletedTime"),
 * 								pulumi.String("RemainingRetentionDays"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container2"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule2"),
 * 					},
 * 				},
 * 				Type: pulumi.String(storage.InventoryRuleTypeInventory),
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(BlobInventoryPolicySchemaArgs.builder()
 *                 .enabled(true)
 *                 .rules(
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .filters(BlobInventoryPolicyFilterArgs.builder()
 *                                 .blobTypes(
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob")
 *                                 .excludePrefix(
 *                                     "excludeprefix1",
 *                                     "excludeprefix2")
 *                                 .includeBlobVersions(true)
 *                                 .includeDeleted(true)
 *                                 .includeSnapshots(true)
 *                                 .prefixMatch(
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                                 .build())
 *                             .format("Csv")
 *                             .objectType("Blob")
 *                             .schedule("Daily")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "ContentType",
 *                                 "ContentEncoding",
 *                                 "ContentLanguage",
 *                                 "ContentCRC64",
 *                                 "CacheControl",
 *                                 "Metadata",
 *                                 "DeletionId",
 *                                 "Deleted",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                             .build())
 *                         .destination("container1")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule1")
 *                         .build(),
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .format("Parquet")
 *                             .objectType("Container")
 *                             .schedule("Weekly")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold",
 *                                 "Etag",
 *                                 "DefaultEncryptionScope",
 *                                 "DenyEncryptionScopeOverride",
 *                                 "ImmutableStorageWithVersioningEnabled",
 *                                 "Deleted",
 *                                 "Version",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                             .build())
 *                         .destination("container2")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule2")
 *                         .build())
 *                 .type("Inventory")
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForNonHnsAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeDeleted = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = AzureNative.Storage.Format.Csv,
 *                         ObjectType = AzureNative.Storage.ObjectType.Blob,
 *                         Schedule = AzureNative.Storage.Schedule.Daily,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "Tags",
 *                             "ContentType",
 *                             "ContentEncoding",
 *                             "ContentLanguage",
 *                             "ContentCRC64",
 *                             "CacheControl",
 *                             "Metadata",
 *                             "Deleted",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = AzureNative.Storage.Format.Parquet,
 *                         ObjectType = AzureNative.Storage.ObjectType.Container,
 *                         Schedule = AzureNative.Storage.Schedule.Weekly,
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                             "Etag",
 *                             "DefaultEncryptionScope",
 *                             "DenyEncryptionScopeOverride",
 *                             "ImmutableStorageWithVersioningEnabled",
 *                             "Deleted",
 *                             "Version",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = AzureNative.Storage.InventoryRuleType.Inventory,
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * 			AccountName:             pulumi.String("sto9699"),
 * 			BlobInventoryPolicyName: pulumi.String("default"),
 * 			Policy: &storage.BlobInventoryPolicySchemaArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				Rules: storage.BlobInventoryPolicyRuleArray{
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Filters: &storage.BlobInventoryPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 									pulumi.String("appendBlob"),
 * 									pulumi.String("pageBlob"),
 * 								},
 * 								ExcludePrefix: pulumi.StringArray{
 * 									pulumi.String("excludeprefix1"),
 * 									pulumi.String("excludeprefix2"),
 * 								},
 * 								IncludeBlobVersions: pulumi.Bool(true),
 * 								IncludeDeleted:      pulumi.Bool(true),
 * 								IncludeSnapshots:    pulumi.Bool(true),
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("inventoryprefix1"),
 * 									pulumi.String("inventoryprefix2"),
 * 								},
 * 							},
 * 							Format:     pulumi.String(storage.FormatCsv),
 * 							ObjectType: pulumi.String(storage.ObjectTypeBlob),
 * 							Schedule:   pulumi.String(storage.ScheduleDaily),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Creation-Time"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Content-Length"),
 * 								pulumi.String("Content-MD5"),
 * 								pulumi.String("BlobType"),
 * 								pulumi.String("AccessTier"),
 * 								pulumi.String("AccessTierChangeTime"),
 * 								pulumi.String("Snapshot"),
 * 								pulumi.String("VersionId"),
 * 								pulumi.String("IsCurrentVersion"),
 * 								pulumi.String("Tags"),
 * 								pulumi.String("ContentType"),
 * 								pulumi.String("ContentEncoding"),
 * 								pulumi.String("ContentLanguage"),
 * 								pulumi.String("ContentCRC64"),
 * 								pulumi.String("CacheControl"),
 * 								pulumi.String("Metadata"),
 * 								pulumi.String("Deleted"),
 * 								pulumi.String("RemainingRetentionDays"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container1"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule1"),
 * 					},
 * 					&storage.BlobInventoryPolicyRuleArgs{
 * 						Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * 							Format:     pulumi.String(storage.FormatParquet),
 * 							ObjectType: pulumi.String(storage.ObjectTypeContainer),
 * 							Schedule:   pulumi.String(storage.ScheduleWeekly),
 * 							SchemaFields: pulumi.StringArray{
 * 								pulumi.String("Name"),
 * 								pulumi.String("Last-Modified"),
 * 								pulumi.String("Metadata"),
 * 								pulumi.String("LeaseStatus"),
 * 								pulumi.String("LeaseState"),
 * 								pulumi.String("LeaseDuration"),
 * 								pulumi.String("PublicAccess"),
 * 								pulumi.String("HasImmutabilityPolicy"),
 * 								pulumi.String("HasLegalHold"),
 * 								pulumi.String("Etag"),
 * 								pulumi.String("DefaultEncryptionScope"),
 * 								pulumi.String("DenyEncryptionScopeOverride"),
 * 								pulumi.String("ImmutableStorageWithVersioningEnabled"),
 * 								pulumi.String("Deleted"),
 * 								pulumi.String("Version"),
 * 								pulumi.String("DeletedTime"),
 * 								pulumi.String("RemainingRetentionDays"),
 * 							},
 * 						},
 * 						Destination: pulumi.String("container2"),
 * 						Enabled:     pulumi.Bool(true),
 * 						Name:        pulumi.String("inventoryPolicyRule2"),
 * 					},
 * 				},
 * 				Type: pulumi.String(storage.InventoryRuleTypeInventory),
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(BlobInventoryPolicySchemaArgs.builder()
 *                 .enabled(true)
 *                 .rules(
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .filters(BlobInventoryPolicyFilterArgs.builder()
 *                                 .blobTypes(
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob")
 *                                 .excludePrefix(
 *                                     "excludeprefix1",
 *                                     "excludeprefix2")
 *                                 .includeBlobVersions(true)
 *                                 .includeDeleted(true)
 *                                 .includeSnapshots(true)
 *                                 .prefixMatch(
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                                 .build())
 *                             .format("Csv")
 *                             .objectType("Blob")
 *                             .schedule("Daily")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "Tags",
 *                                 "ContentType",
 *                                 "ContentEncoding",
 *                                 "ContentLanguage",
 *                                 "ContentCRC64",
 *                                 "CacheControl",
 *                                 "Metadata",
 *                                 "Deleted",
 *                                 "RemainingRetentionDays")
 *                             .build())
 *                         .destination("container1")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule1")
 *                         .build(),
 *                     BlobInventoryPolicyRuleArgs.builder()
 *                         .definition(BlobInventoryPolicyDefinitionArgs.builder()
 *                             .format("Parquet")
 *                             .objectType("Container")
 *                             .schedule("Weekly")
 *                             .schemaFields(
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold",
 *                                 "Etag",
 *                                 "DefaultEncryptionScope",
 *                                 "DenyEncryptionScopeOverride",
 *                                 "ImmutableStorageWithVersioningEnabled",
 *                                 "Deleted",
 *                                 "Version",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                             .build())
 *                         .destination("container2")
 *                         .enabled(true)
 *                         .name("inventoryPolicyRule2")
 *                         .build())
 *                 .type("Inventory")
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobInventoryPolicy DefaultInventoryPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies/{blobInventoryPolicyName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property blobInventoryPolicyName The name of the storage account blob inventory policy. It should always be 'default'
 * @property policy The storage account blob inventory policy object. It is composed of policy rules.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class BlobInventoryPolicyArgs(
    public val accountName: Output<String>? = null,
    public val blobInventoryPolicyName: Output<String>? = null,
    public val policy: Output<BlobInventoryPolicySchemaArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobInventoryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobInventoryPolicyArgs =
        com.pulumi.azurenative.storage.BlobInventoryPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .blobInventoryPolicyName(blobInventoryPolicyName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobInventoryPolicyArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var blobInventoryPolicyName: Output<String>? = null

    private var policy: Output<BlobInventoryPolicySchemaArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("inauompmxkcftvqo")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the storage account blob inventory policy. It should always be 'default'
     */
    @JvmName("ifvlcmgqstgpnffj")
    public suspend fun blobInventoryPolicyName(`value`: Output<String>) {
        this.blobInventoryPolicyName = value
    }

    /**
     * @param value The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("dtmcseoeqhllydkl")
    public suspend fun policy(`value`: Output<BlobInventoryPolicySchemaArgs>) {
        this.policy = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("eotqlhuhyivxgmqd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("qejcbvapnkfeudcf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the storage account blob inventory policy. It should always be 'default'
     */
    @JvmName("fcjcnrwhlnfftish")
    public suspend fun blobInventoryPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobInventoryPolicyName = mapped
    }

    /**
     * @param value The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("xfnkhkinirgmumre")
    public suspend fun policy(`value`: BlobInventoryPolicySchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("mfmiueiwwgtjrnos")
    public suspend fun policy(argument: suspend BlobInventoryPolicySchemaArgsBuilder.() -> Unit) {
        val toBeMapped = BlobInventoryPolicySchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kpfurhnngjbeqndo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): BlobInventoryPolicyArgs = BlobInventoryPolicyArgs(
        accountName = accountName,
        blobInventoryPolicyName = blobInventoryPolicyName,
        policy = policy,
        resourceGroupName = resourceGroupName,
    )
}
