@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.ChangeFeedResponse
import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.LastAccessTimeTrackingPolicyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.RestorePolicyPropertiesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storage.kotlin.outputs.ChangeFeedResponse.Companion.toKotlin as changeFeedResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse.Companion.toKotlin as corsRulesResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse.Companion.toKotlin as deleteRetentionPolicyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.LastAccessTimeTrackingPolicyResponse.Companion.toKotlin as lastAccessTimeTrackingPolicyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.RestorePolicyPropertiesResponse.Companion.toKotlin as restorePolicyPropertiesResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [BlobServiceProperties].
 */
@PulumiTagMarker
public class BlobServicePropertiesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobServicePropertiesArgs = BlobServicePropertiesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobServicePropertiesArgsBuilder.() -> Unit) {
        val builder = BlobServicePropertiesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobServiceProperties {
        val builtJavaResource =
            com.pulumi.azurenative.storage.BlobServiceProperties(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlobServiceProperties(builtJavaResource)
    }
}

/**
 * The properties of a storage account’s Blob service.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### BlobServicesPutAllowPermanentDelete
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         DeleteRetentionPolicy = new AzureNative.Storage.Inputs.DeleteRetentionPolicyArgs
 *         {
 *             AllowPermanentDelete = true,
 *             Days = 300,
 *             Enabled = true,
 *         },
 *         IsVersioningEnabled = true,
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			DeleteRetentionPolicy: &storage.DeleteRetentionPolicyArgs{
 * 				AllowPermanentDelete: pulumi.Bool(true),
 * 				Days:                 pulumi.Int(300),
 * 				Enabled:              pulumi.Bool(true),
 * 			},
 * 			IsVersioningEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:   pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .deleteRetentionPolicy(DeleteRetentionPolicyArgs.builder()
 *                 .allowPermanentDelete(true)
 *                 .days(300)
 *                 .enabled(true)
 *                 .build())
 *             .isVersioningEnabled(true)
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### BlobServicesPutLastAccessTimeBasedTracking
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         LastAccessTimeTrackingPolicy = new AzureNative.Storage.Inputs.LastAccessTimeTrackingPolicyArgs
 *         {
 *             BlobType = new[]
 *             {
 *                 "blockBlob",
 *             },
 *             Enable = true,
 *             Name = AzureNative.Storage.Name.AccessTimeTracking,
 *             TrackingGranularityInDays = 1,
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			LastAccessTimeTrackingPolicy: &storage.LastAccessTimeTrackingPolicyArgs{
 * 				BlobType: pulumi.StringArray{
 * 					pulumi.String("blockBlob"),
 * 				},
 * 				Enable:                    pulumi.Bool(true),
 * 				Name:                      pulumi.String(storage.NameAccessTimeTracking),
 * 				TrackingGranularityInDays: pulumi.Int(1),
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.LastAccessTimeTrackingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .lastAccessTimeTrackingPolicy(LastAccessTimeTrackingPolicyArgs.builder()
 *                 .blobType("blockBlob")
 *                 .enable(true)
 *                 .name("AccessTimeTracking")
 *                 .trackingGranularityInDays(1)
 *                 .build())
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutBlobServices
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobServiceProperties = new AzureNative.Storage.BlobServiceProperties("blobServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         BlobServicesName = "default",
 *         ChangeFeed = new AzureNative.Storage.Inputs.ChangeFeedArgs
 *         {
 *             Enabled = true,
 *             RetentionInDays = 7,
 *         },
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.HEAD,
 *                         AzureNative.Storage.AllowedMethods.POST,
 *                         AzureNative.Storage.AllowedMethods.OPTIONS,
 *                         AzureNative.Storage.AllowedMethods.MERGE,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x -ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         DefaultServiceVersion = "2017-07-29",
 *         DeleteRetentionPolicy = new AzureNative.Storage.Inputs.DeleteRetentionPolicyArgs
 *         {
 *             Days = 300,
 *             Enabled = true,
 *         },
 *         IsVersioningEnabled = true,
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobServiceProperties(ctx, "blobServiceProperties", &storage.BlobServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			BlobServicesName: pulumi.String("default"),
 * 			ChangeFeed: &storage.ChangeFeedArgs{
 * 				Enabled:         pulumi.Bool(true),
 * 				RetentionInDays: pulumi.Int(7),
 * 			},
 * 			Cors: &storage.CorsRulesArgs{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsHEAD),
 * 							pulumi.String(storage.AllowedMethodsPOST),
 * 							pulumi.String(storage.AllowedMethodsOPTIONS),
 * 							pulumi.String(storage.AllowedMethodsMERGE),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x -ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			DefaultServiceVersion: pulumi.String("2017-07-29"),
 * 			DeleteRetentionPolicy: &storage.DeleteRetentionPolicyArgs{
 * 				Days:    pulumi.Int(300),
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			IsVersioningEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:   pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobServiceProperties;
 * import com.pulumi.azurenative.storage.BlobServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.ChangeFeedArgs;
 * import com.pulumi.azurenative.storage.inputs.CorsRulesArgs;
 * import com.pulumi.azurenative.storage.inputs.DeleteRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobServiceProperties = new BlobServiceProperties("blobServiceProperties", BlobServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .blobServicesName("default")
 *             .changeFeed(ChangeFeedArgs.builder()
 *                 .enabled(true)
 *                 .retentionInDays(7)
 *                 .build())
 *             .cors(CorsRulesArgs.builder()
 *                 .corsRules(
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x-ms-meta-target*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "HEAD",
 *                             "POST",
 *                             "OPTIONS",
 *                             "MERGE",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.contoso.com",
 *                             "http://www.fabrikam.com")
 *                         .exposedHeaders("x-ms-meta-*")
 *                         .maxAgeInSeconds(100)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("*")
 *                         .allowedMethods("GET")
 *                         .allowedOrigins("*")
 *                         .exposedHeaders("*")
 *                         .maxAgeInSeconds(2)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("x-ms-meta-12345675754564*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.abc23.com",
 *                             "https://www.fabrikam.com/*")
 *                         .exposedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x -ms-meta-target*")
 *                         .maxAgeInSeconds(2000)
 *                         .build())
 *                 .build())
 *             .defaultServiceVersion("2017-07-29")
 *             .deleteRetentionPolicy(DeleteRetentionPolicyArgs.builder()
 *                 .days(300)
 *                 .enabled(true)
 *                 .build())
 *             .isVersioningEnabled(true)
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/{BlobServicesName}
 * ```
 * */*/*/
 */
public class BlobServiceProperties internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.BlobServiceProperties,
) : KotlinCustomResource(javaResource, BlobServicePropertiesMapper) {
    /**
     * Deprecated in favor of isVersioningEnabled property.
     */
    public val automaticSnapshotPolicyEnabled: Output<Boolean>?
        get() = javaResource.automaticSnapshotPolicyEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The blob service properties for change feed events.
     */
    public val changeFeed: Output<ChangeFeedResponse>?
        get() = javaResource.changeFeed().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    changeFeedResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The blob service properties for container soft delete.
     */
    public val containerDeleteRetentionPolicy: Output<DeleteRetentionPolicyResponse>?
        get() = javaResource.containerDeleteRetentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deleteRetentionPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
     */
    public val cors: Output<CorsRulesResponse>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    corsRulesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
     */
    public val defaultServiceVersion: Output<String>?
        get() = javaResource.defaultServiceVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The blob service properties for blob soft delete.
     */
    public val deleteRetentionPolicy: Output<DeleteRetentionPolicyResponse>?
        get() = javaResource.deleteRetentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deleteRetentionPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Versioning is enabled if set to true.
     */
    public val isVersioningEnabled: Output<Boolean>?
        get() = javaResource.isVersioningEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The blob service property to configure last access time based tracking policy.
     */
    public val lastAccessTimeTrackingPolicy: Output<LastAccessTimeTrackingPolicyResponse>?
        get() = javaResource.lastAccessTimeTrackingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> lastAccessTimeTrackingPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The blob service properties for blob restore policy.
     */
    public val restorePolicy: Output<RestorePolicyPropertiesResponse>?
        get() = javaResource.restorePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> restorePolicyPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sku name and tier.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BlobServicePropertiesMapper : ResourceMapper<BlobServiceProperties> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.BlobServiceProperties::class == javaResource::class

    override fun map(javaResource: Resource): BlobServiceProperties =
        BlobServiceProperties(javaResource as com.pulumi.azurenative.storage.BlobServiceProperties)
}

/**
 * @see [BlobServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobServiceProperties].
 */
public suspend fun blobServiceProperties(
    name: String,
    block: suspend BlobServicePropertiesResourceBuilder.() -> Unit,
): BlobServiceProperties {
    val builder = BlobServicePropertiesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobServiceProperties(name: String): BlobServiceProperties {
    val builder = BlobServicePropertiesResourceBuilder()
    builder.name(name)
    return builder.build()
}
