@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.StorageAccountArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.AccessTier
import com.pulumi.azurenative.storage.kotlin.enums.AllowedCopyScope
import com.pulumi.azurenative.storage.kotlin.enums.DnsEndpointType
import com.pulumi.azurenative.storage.kotlin.enums.Kind
import com.pulumi.azurenative.storage.kotlin.enums.LargeFileSharesState
import com.pulumi.azurenative.storage.kotlin.enums.MinimumTlsVersion
import com.pulumi.azurenative.storage.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.storage.kotlin.inputs.AzureFilesIdentityBasedAuthenticationArgs
import com.pulumi.azurenative.storage.kotlin.inputs.AzureFilesIdentityBasedAuthenticationArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.CustomDomainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CustomDomainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.storage.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageAccountArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ImmutableStorageAccountArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.KeyPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.KeyPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.NetworkRuleSetArgs
import com.pulumi.azurenative.storage.kotlin.inputs.NetworkRuleSetArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.RoutingPreferenceArgs
import com.pulumi.azurenative.storage.kotlin.inputs.RoutingPreferenceArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.SasPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SasPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2015-05-01-preview, 2015-06-15, 2018-11-01, 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### NfsV3AccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         EnableHttpsTrafficOnly = false,
 *         EnableNfsV3 = true,
 *         IsHnsEnabled = true,
 *         Kind = AzureNative.Storage.Kind.BlockBlobStorage,
 *         Location = "eastus",
 *         NetworkRuleSet = new AzureNative.Storage.Inputs.NetworkRuleSetArgs
 *         {
 *             Bypass = AzureNative.Storage.Bypass.AzureServices,
 *             DefaultAction = AzureNative.Storage.DefaultAction.Allow,
 *             IpRules = new() { },
 *             VirtualNetworkRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.VirtualNetworkRuleArgs
 *                 {
 *                     VirtualNetworkResourceId = "/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Premium_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:            pulumi.String("sto4445"),
 * 			EnableHttpsTrafficOnly: pulumi.Bool(false),
 * 			EnableNfsV3:            pulumi.Bool(true),
 * 			IsHnsEnabled:           pulumi.Bool(true),
 * 			Kind:                   pulumi.String(storage.KindBlockBlobStorage),
 * 			Location:               pulumi.String("eastus"),
 * 			NetworkRuleSet: &storage.NetworkRuleSetArgs{
 * 				Bypass:        pulumi.String(storage.BypassAzureServices),
 * 				DefaultAction: storage.DefaultActionAllow,
 * 				IpRules:       storage.IPRuleArray{},
 * 				VirtualNetworkRules: storage.VirtualNetworkRuleArray{
 * 					&storage.VirtualNetworkRuleArgs{
 * 						VirtualNetworkResourceId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Premium_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .enableHttpsTrafficOnly(false)
 *             .enableNfsV3(true)
 *             .isHnsEnabled(true)
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .networkRuleSet(NetworkRuleSetArgs.builder()
 *                 .bypass("AzureServices")
 *                 .defaultAction("Allow")
 *                 .ipRules()
 *                 .virtualNetworkRules(VirtualNetworkRuleArgs.builder()
 *                     .virtualNetworkResourceId("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToAAD
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = AzureNative.Storage.AllowedCopyScope.AAD,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			AllowedCopyScope:      pulumi.String(storage.AllowedCopyScopeAAD),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("AAD")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToPrivateLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = AzureNative.Storage.AllowedCopyScope.PrivateLink,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			AllowedCopyScope:      pulumi.String(storage.AllowedCopyScopePrivateLink),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("PrivateLink")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDisallowPublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         PublicNetworkAccess = AzureNative.Storage.PublicNetworkAccess.Disabled,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:                pulumi.String(storage.KindStorage),
 * 			Location:            pulumi.String("eastus"),
 * 			MinimumTlsVersion:   pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			PublicNetworkAccess: pulumi.String(storage.PublicNetworkAccessDisabled),
 * 			ResourceGroupName:   pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToAzureDnsZone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = AzureNative.Storage.DnsEndpointType.AzureDnsZone,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			DnsEndpointType:              pulumi.String(storage.DnsEndpointTypeAzureDnsZone),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("AzureDnsZone")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToStandard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = AzureNative.Storage.DnsEndpointType.Standard,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			DnsEndpointType:              pulumi.String(storage.DnsEndpointTypeStandard),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("Standard")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateEnablePublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         PublicNetworkAccess = AzureNative.Storage.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:                pulumi.String(storage.KindStorage),
 * 			Location:            pulumi.String("eastus"),
 * 			MinimumTlsVersion:   pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			PublicNetworkAccess: pulumi.String(storage.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreatePremiumBlockBlobStorage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         Kind = AzureNative.Storage.Kind.BlockBlobStorage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Premium_LRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:          pulumi.String("sto4445"),
 * 			AllowSharedKeyAccess: pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			Kind:              pulumi.String(storage.KindBlockBlobStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Premium_LRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateWithImmutabilityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         ImmutableStorageWithVersioning = new AzureNative.Storage.Inputs.ImmutableStorageAccountArgs
 *         {
 *             Enabled = true,
 *             ImmutabilityPolicy = new AzureNative.Storage.Inputs.AccountImmutabilityPolicyPropertiesArgs
 *             {
 *                 AllowProtectedAppendWrites = true,
 *                 ImmutabilityPeriodSinceCreationInDays = 15,
 *                 State = AzureNative.Storage.AccountImmutabilityPolicyState.Unlocked,
 *             },
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName: pulumi.String("sto4445"),
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			ImmutableStorageWithVersioning: &storage.ImmutableStorageAccountArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				ImmutabilityPolicy: &storage.AccountImmutabilityPolicyPropertiesArgs{
 * 					AllowProtectedAppendWrites:            pulumi.Bool(true),
 * 					ImmutabilityPeriodSinceCreationInDays: pulumi.Int(15),
 * 					State:                                 pulumi.String(storage.AccountImmutabilityPolicyStateUnlocked),
 * 				},
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .immutableStorageWithVersioning(ImmutableStorageAccountArgs.builder()
 *                 .enabled(true)
 *                 .immutabilityPolicy(AccountImmutabilityPolicyPropertiesArgs.builder()
 *                     .allowProtectedAppendWrites(true)
 *                     .immutabilityPeriodSinceCreationInDays(15)
 *                     .state("Unlocked")
 *                     .build())
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageAccount sto4445 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}
 * ```
 * @property accessTier Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property allowBlobPublicAccess Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
 * @property allowCrossTenantReplication Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
 * @property allowSharedKeyAccess Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
 * @property allowedCopyScope Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
 * @property azureFilesIdentityBasedAuthentication Provides the identity based authentication settings for Azure Files.
 * @property customDomain User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
 * @property defaultToOAuthAuthentication A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
 * @property dnsEndpointType Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
 * @property enableHttpsTrafficOnly Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
 * @property enableNfsV3 NFS 3.0 protocol support enabled if set to true.
 * @property encryption Encryption settings to be used for server-side encryption for the storage account.
 * @property extendedLocation Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
 * @property identity The identity of the resource.
 * @property immutableStorageWithVersioning The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
 * @property isHnsEnabled Account HierarchicalNamespace enabled if sets to true.
 * @property isLocalUserEnabled Enables local users feature, if set to true
 * @property isSftpEnabled Enables Secure File Transfer Protocol, if set to true
 * @property keyPolicy KeyPolicy assigned to the storage account.
 * @property kind Required. Indicates the type of storage account.
 * @property largeFileSharesState Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
 * @property location Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
 * @property minimumTlsVersion Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
 * @property networkRuleSet Network rule set
 * @property publicNetworkAccess Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property routingPreference Maintains information about the network routing choice opted by the user for data transfer
 * @property sasPolicy SasPolicy assigned to the storage account.
 * @property sku Required. Gets or sets the SKU name.
 * @property tags Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
 */
public data class StorageAccountArgs(
    public val accessTier: Output<AccessTier>? = null,
    public val accountName: Output<String>? = null,
    public val allowBlobPublicAccess: Output<Boolean>? = null,
    public val allowCrossTenantReplication: Output<Boolean>? = null,
    public val allowSharedKeyAccess: Output<Boolean>? = null,
    public val allowedCopyScope: Output<Either<String, AllowedCopyScope>>? = null,
    public val azureFilesIdentityBasedAuthentication: Output<AzureFilesIdentityBasedAuthenticationArgs>? = null,
    public val customDomain: Output<CustomDomainArgs>? = null,
    public val defaultToOAuthAuthentication: Output<Boolean>? = null,
    public val dnsEndpointType: Output<Either<String, DnsEndpointType>>? = null,
    public val enableHttpsTrafficOnly: Output<Boolean>? = null,
    public val enableNfsV3: Output<Boolean>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val immutableStorageWithVersioning: Output<ImmutableStorageAccountArgs>? = null,
    public val isHnsEnabled: Output<Boolean>? = null,
    public val isLocalUserEnabled: Output<Boolean>? = null,
    public val isSftpEnabled: Output<Boolean>? = null,
    public val keyPolicy: Output<KeyPolicyArgs>? = null,
    public val kind: Output<Either<String, Kind>>? = null,
    public val largeFileSharesState: Output<Either<String, LargeFileSharesState>>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null,
    public val networkRuleSet: Output<NetworkRuleSetArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingPreference: Output<RoutingPreferenceArgs>? = null,
    public val sasPolicy: Output<SasPolicyArgs>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.StorageAccountArgs =
        com.pulumi.azurenative.storage.StorageAccountArgs.builder()
            .accessTier(accessTier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowBlobPublicAccess(allowBlobPublicAccess?.applyValue({ args0 -> args0 }))
            .allowCrossTenantReplication(allowCrossTenantReplication?.applyValue({ args0 -> args0 }))
            .allowSharedKeyAccess(allowSharedKeyAccess?.applyValue({ args0 -> args0 }))
            .allowedCopyScope(
                allowedCopyScope?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureFilesIdentityBasedAuthentication(
                azureFilesIdentityBasedAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .customDomain(customDomain?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultToOAuthAuthentication(defaultToOAuthAuthentication?.applyValue({ args0 -> args0 }))
            .dnsEndpointType(
                dnsEndpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableHttpsTrafficOnly(enableHttpsTrafficOnly?.applyValue({ args0 -> args0 }))
            .enableNfsV3(enableNfsV3?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .immutableStorageWithVersioning(
                immutableStorageWithVersioning?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .isHnsEnabled(isHnsEnabled?.applyValue({ args0 -> args0 }))
            .isLocalUserEnabled(isLocalUserEnabled?.applyValue({ args0 -> args0 }))
            .isSftpEnabled(isSftpEnabled?.applyValue({ args0 -> args0 }))
            .keyPolicy(keyPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .largeFileSharesState(
                largeFileSharesState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkRuleSet(networkRuleSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingPreference(routingPreference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasPolicy(sasPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var accessTier: Output<AccessTier>? = null

    private var accountName: Output<String>? = null

    private var allowBlobPublicAccess: Output<Boolean>? = null

    private var allowCrossTenantReplication: Output<Boolean>? = null

    private var allowSharedKeyAccess: Output<Boolean>? = null

    private var allowedCopyScope: Output<Either<String, AllowedCopyScope>>? = null

    private var azureFilesIdentityBasedAuthentication:
        Output<AzureFilesIdentityBasedAuthenticationArgs>? = null

    private var customDomain: Output<CustomDomainArgs>? = null

    private var defaultToOAuthAuthentication: Output<Boolean>? = null

    private var dnsEndpointType: Output<Either<String, DnsEndpointType>>? = null

    private var enableHttpsTrafficOnly: Output<Boolean>? = null

    private var enableNfsV3: Output<Boolean>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var immutableStorageWithVersioning: Output<ImmutableStorageAccountArgs>? = null

    private var isHnsEnabled: Output<Boolean>? = null

    private var isLocalUserEnabled: Output<Boolean>? = null

    private var isSftpEnabled: Output<Boolean>? = null

    private var keyPolicy: Output<KeyPolicyArgs>? = null

    private var kind: Output<Either<String, Kind>>? = null

    private var largeFileSharesState: Output<Either<String, LargeFileSharesState>>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, MinimumTlsVersion>>? = null

    private var networkRuleSet: Output<NetworkRuleSetArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingPreference: Output<RoutingPreferenceArgs>? = null

    private var sasPolicy: Output<SasPolicyArgs>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
     */
    @JvmName("hipqycwhhrspxhet")
    public suspend fun accessTier(`value`: Output<AccessTier>) {
        this.accessTier = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("eoskqqocdiqcbkkr")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
     */
    @JvmName("tndtkrxxpufrhcfg")
    public suspend fun allowBlobPublicAccess(`value`: Output<Boolean>) {
        this.allowBlobPublicAccess = value
    }

    /**
     * @param value Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
     */
    @JvmName("gyuhkkbmhgfibwnd")
    public suspend fun allowCrossTenantReplication(`value`: Output<Boolean>) {
        this.allowCrossTenantReplication = value
    }

    /**
     * @param value Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    @JvmName("aenypgcjxcvbpatq")
    public suspend fun allowSharedKeyAccess(`value`: Output<Boolean>) {
        this.allowSharedKeyAccess = value
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("kiatpghjoeiibaon")
    public suspend fun allowedCopyScope(`value`: Output<Either<String, AllowedCopyScope>>) {
        this.allowedCopyScope = value
    }

    /**
     * @param value Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("wahfekkeovimtetp")
    public suspend fun azureFilesIdentityBasedAuthentication(`value`: Output<AzureFilesIdentityBasedAuthenticationArgs>) {
        this.azureFilesIdentityBasedAuthentication = value
    }

    /**
     * @param value User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("cnaccbsuuhbisaer")
    public suspend fun customDomain(`value`: Output<CustomDomainArgs>) {
        this.customDomain = value
    }

    /**
     * @param value A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
     */
    @JvmName("nwikmvecxemavxup")
    public suspend fun defaultToOAuthAuthentication(`value`: Output<Boolean>) {
        this.defaultToOAuthAuthentication = value
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("bxysjrcfvmmrmcyx")
    public suspend fun dnsEndpointType(`value`: Output<Either<String, DnsEndpointType>>) {
        this.dnsEndpointType = value
    }

    /**
     * @param value Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
     */
    @JvmName("okeyreciyehwtudx")
    public suspend fun enableHttpsTrafficOnly(`value`: Output<Boolean>) {
        this.enableHttpsTrafficOnly = value
    }

    /**
     * @param value NFS 3.0 protocol support enabled if set to true.
     */
    @JvmName("fopheeceljkmcfpl")
    public suspend fun enableNfsV3(`value`: Output<Boolean>) {
        this.enableNfsV3 = value
    }

    /**
     * @param value Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("wkbpeyacatfhydsd")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("tpdjmcjcgrliajvl")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("iuofwsxuiwyjehxm")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("fwborxsjrfvagcwe")
    public suspend fun immutableStorageWithVersioning(`value`: Output<ImmutableStorageAccountArgs>) {
        this.immutableStorageWithVersioning = value
    }

    /**
     * @param value Account HierarchicalNamespace enabled if sets to true.
     */
    @JvmName("ooeskddhpqsghada")
    public suspend fun isHnsEnabled(`value`: Output<Boolean>) {
        this.isHnsEnabled = value
    }

    /**
     * @param value Enables local users feature, if set to true
     */
    @JvmName("mcrmybcnubpsoyky")
    public suspend fun isLocalUserEnabled(`value`: Output<Boolean>) {
        this.isLocalUserEnabled = value
    }

    /**
     * @param value Enables Secure File Transfer Protocol, if set to true
     */
    @JvmName("btqjimvmqaxquhnh")
    public suspend fun isSftpEnabled(`value`: Output<Boolean>) {
        this.isSftpEnabled = value
    }

    /**
     * @param value KeyPolicy assigned to the storage account.
     */
    @JvmName("akimvnrsdpylaftd")
    public suspend fun keyPolicy(`value`: Output<KeyPolicyArgs>) {
        this.keyPolicy = value
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("rmlmwnxftdgfkhgo")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("vgugxhutmhjxbtgb")
    public suspend fun largeFileSharesState(`value`: Output<Either<String, LargeFileSharesState>>) {
        this.largeFileSharesState = value
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("ujhmnarqerwvtxom")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("hqqknxqcatomxrqg")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, MinimumTlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value Network rule set
     */
    @JvmName("oxeuuoiqavtusxte")
    public suspend fun networkRuleSet(`value`: Output<NetworkRuleSetArgs>) {
        this.networkRuleSet = value
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("temxtjtgnidromxs")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("bkabauapnxafsxcf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("qpdcxgbpeffcihkl")
    public suspend fun routingPreference(`value`: Output<RoutingPreferenceArgs>) {
        this.routingPreference = value
    }

    /**
     * @param value SasPolicy assigned to the storage account.
     */
    @JvmName("ntwopwmvqjbingmq")
    public suspend fun sasPolicy(`value`: Output<SasPolicyArgs>) {
        this.sasPolicy = value
    }

    /**
     * @param value Required. Gets or sets the SKU name.
     */
    @JvmName("foiyhvsotubiqjmv")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("tehsvpapbjtnefpi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
     */
    @JvmName("duijddgatogdnpcv")
    public suspend fun accessTier(`value`: AccessTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("yomtckaeekkqnyqy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
     */
    @JvmName("qdcyppotekwwvswc")
    public suspend fun allowBlobPublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowBlobPublicAccess = mapped
    }

    /**
     * @param value Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
     */
    @JvmName("qiximgrmptplhsnh")
    public suspend fun allowCrossTenantReplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCrossTenantReplication = mapped
    }

    /**
     * @param value Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    @JvmName("bhojvjvbyxuulufe")
    public suspend fun allowSharedKeyAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSharedKeyAccess = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("xybsumwtyiinfacn")
    public suspend fun allowedCopyScope(`value`: Either<String, AllowedCopyScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("egrmpwwulguoixeb")
    public fun allowedCopyScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowedCopyScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    @JvmName("pueovutexktvorhx")
    public fun allowedCopyScope(`value`: AllowedCopyScope) {
        val toBeMapped = Either.ofRight<String, AllowedCopyScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedCopyScope = mapped
    }

    /**
     * @param value Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("lcximgnkeatkbike")
    public suspend fun azureFilesIdentityBasedAuthentication(`value`: AzureFilesIdentityBasedAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFilesIdentityBasedAuthentication = mapped
    }

    /**
     * @param argument Provides the identity based authentication settings for Azure Files.
     */
    @JvmName("jendllwyougsxheb")
    public suspend fun azureFilesIdentityBasedAuthentication(argument: suspend AzureFilesIdentityBasedAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFilesIdentityBasedAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureFilesIdentityBasedAuthentication = mapped
    }

    /**
     * @param value User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("jrvrekqgbplgawgc")
    public suspend fun customDomain(`value`: CustomDomainArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomain = mapped
    }

    /**
     * @param argument User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage account at this time. To clear the existing custom domain, use an empty string for the custom domain name property.
     */
    @JvmName("keguuaroksorfbde")
    public suspend fun customDomain(argument: suspend CustomDomainArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDomainArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customDomain = mapped
    }

    /**
     * @param value A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
     */
    @JvmName("tsuaihdfjscwsvbp")
    public suspend fun defaultToOAuthAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultToOAuthAuthentication = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("gvaiqamhumefxhvw")
    public suspend fun dnsEndpointType(`value`: Either<String, DnsEndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("vbeteiqcgavusnnq")
    public fun dnsEndpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DnsEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    @JvmName("fhbnjpthcbrlfesm")
    public fun dnsEndpointType(`value`: DnsEndpointType) {
        val toBeMapped = Either.ofRight<String, DnsEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsEndpointType = mapped
    }

    /**
     * @param value Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
     */
    @JvmName("ijplakiywjfhlant")
    public suspend fun enableHttpsTrafficOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHttpsTrafficOnly = mapped
    }

    /**
     * @param value NFS 3.0 protocol support enabled if set to true.
     */
    @JvmName("vnnoyygrwtqgctut")
    public suspend fun enableNfsV3(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNfsV3 = mapped
    }

    /**
     * @param value Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("qjpkkdxenhgkxhxs")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Encryption settings to be used for server-side encryption for the storage account.
     */
    @JvmName("pnxpmljawdhopvmi")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("rubojvlvsjdpfcpa")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region. Otherwise it will be created in the specified extended location
     */
    @JvmName("bqdjlqfgmkptydgl")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("wrdbkkfykhcvwfns")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("nmmimvcxrboorxpw")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("wvwthhwctknqjgab")
    public suspend fun immutableStorageWithVersioning(`value`: ImmutableStorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param argument The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the new containers in the account by default.
     */
    @JvmName("kmfyjqtukuournmh")
    public suspend fun immutableStorageWithVersioning(argument: suspend ImmutableStorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = ImmutableStorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.immutableStorageWithVersioning = mapped
    }

    /**
     * @param value Account HierarchicalNamespace enabled if sets to true.
     */
    @JvmName("ipkmmcxjkjsxwkon")
    public suspend fun isHnsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isHnsEnabled = mapped
    }

    /**
     * @param value Enables local users feature, if set to true
     */
    @JvmName("cdckxolrvosmchro")
    public suspend fun isLocalUserEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLocalUserEnabled = mapped
    }

    /**
     * @param value Enables Secure File Transfer Protocol, if set to true
     */
    @JvmName("utfskhbgstaichoa")
    public suspend fun isSftpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSftpEnabled = mapped
    }

    /**
     * @param value KeyPolicy assigned to the storage account.
     */
    @JvmName("fyryclgacbjxrsiq")
    public suspend fun keyPolicy(`value`: KeyPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPolicy = mapped
    }

    /**
     * @param argument KeyPolicy assigned to the storage account.
     */
    @JvmName("cyvyagnhqajpoevq")
    public suspend fun keyPolicy(argument: suspend KeyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = KeyPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyPolicy = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("vdugnllfuudwqhsp")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("vmekxkmhmlcgtrop")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Indicates the type of storage account.
     */
    @JvmName("fmklmnvevtxffqhs")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("wxpjxfueecbvpcxn")
    public suspend fun largeFileSharesState(`value`: Either<String, LargeFileSharesState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("qqtbexxohdrelyrk")
    public fun largeFileSharesState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LargeFileSharesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    @JvmName("tqfpnribtlwmsjag")
    public fun largeFileSharesState(`value`: LargeFileSharesState) {
        val toBeMapped = Either.ofRight<String, LargeFileSharesState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.largeFileSharesState = mapped
    }

    /**
     * @param value Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
     */
    @JvmName("xdokeykytpojtpsu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("lnovmjsyrrpjvodu")
    public suspend fun minimumTlsVersion(`value`: Either<String, MinimumTlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("rgghnojuhkvpkocu")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    @JvmName("edllnojwkhnhnadc")
    public fun minimumTlsVersion(`value`: MinimumTlsVersion) {
        val toBeMapped = Either.ofRight<String, MinimumTlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Network rule set
     */
    @JvmName("wnvmacsansvjbjke")
    public suspend fun networkRuleSet(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleSet = mapped
    }

    /**
     * @param argument Network rule set
     */
    @JvmName("ehljxqkiwasokrrl")
    public suspend fun networkRuleSet(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkRuleSet = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("urevvjidpwlmqmvy")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("wcanyylwcnjlygrx")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    @JvmName("nihfdgacwskljcvu")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jpmfmsggaiuksmmo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("rxwbxwxcxpavpoyg")
    public suspend fun routingPreference(`value`: RoutingPreferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingPreference = mapped
    }

    /**
     * @param argument Maintains information about the network routing choice opted by the user for data transfer
     */
    @JvmName("ilqypbjnejmrorsr")
    public suspend fun routingPreference(argument: suspend RoutingPreferenceArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingPreferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingPreference = mapped
    }

    /**
     * @param value SasPolicy assigned to the storage account.
     */
    @JvmName("pwcugcbolhvglixi")
    public suspend fun sasPolicy(`value`: SasPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasPolicy = mapped
    }

    /**
     * @param argument SasPolicy assigned to the storage account.
     */
    @JvmName("symdviqbkirtxlbg")
    public suspend fun sasPolicy(argument: suspend SasPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = SasPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasPolicy = mapped
    }

    /**
     * @param value Required. Gets or sets the SKU name.
     */
    @JvmName("iqfekfggrhixgjtx")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Required. Gets or sets the SKU name.
     */
    @JvmName("uljrumjvbthhucks")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("gtspyffrateckcwk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
     */
    @JvmName("bytimyjplsoasqky")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        accessTier = accessTier,
        accountName = accountName,
        allowBlobPublicAccess = allowBlobPublicAccess,
        allowCrossTenantReplication = allowCrossTenantReplication,
        allowSharedKeyAccess = allowSharedKeyAccess,
        allowedCopyScope = allowedCopyScope,
        azureFilesIdentityBasedAuthentication = azureFilesIdentityBasedAuthentication,
        customDomain = customDomain,
        defaultToOAuthAuthentication = defaultToOAuthAuthentication,
        dnsEndpointType = dnsEndpointType,
        enableHttpsTrafficOnly = enableHttpsTrafficOnly,
        enableNfsV3 = enableNfsV3,
        encryption = encryption,
        extendedLocation = extendedLocation,
        identity = identity,
        immutableStorageWithVersioning = immutableStorageWithVersioning,
        isHnsEnabled = isHnsEnabled,
        isLocalUserEnabled = isLocalUserEnabled,
        isSftpEnabled = isSftpEnabled,
        keyPolicy = keyPolicy,
        kind = kind,
        largeFileSharesState = largeFileSharesState,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        networkRuleSet = networkRuleSet,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        routingPreference = routingPreference,
        sasPolicy = sasPolicy,
        sku = sku,
        tags = tags,
    )
}
