@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.StorageAccountStaticWebsiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables the static website feature of a storage account.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageAccountStaticWebsite myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/staticWebsite
 * ```
 * @property accountName The name of the storage account within the specified resource group.
 * @property error404Document The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
 * @property indexDocument The webpage that Azure Storage serves for requests to the root of a website or any sub-folder. For example, 'index.html'. The value is case-sensitive.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class StorageAccountStaticWebsiteArgs(
    public val accountName: Output<String>? = null,
    public val error404Document: Output<String>? = null,
    public val indexDocument: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.StorageAccountStaticWebsiteArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.StorageAccountStaticWebsiteArgs =
        com.pulumi.azurenative.storage.StorageAccountStaticWebsiteArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .error404Document(error404Document?.applyValue({ args0 -> args0 }))
            .indexDocument(indexDocument?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountStaticWebsiteArgs].
 */
@PulumiTagMarker
public class StorageAccountStaticWebsiteArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var error404Document: Output<String>? = null

    private var indexDocument: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group.
     */
    @JvmName("kydknqabnfasqjqg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
     */
    @JvmName("fhymgvlxlkemyasq")
    public suspend fun error404Document(`value`: Output<String>) {
        this.error404Document = value
    }

    /**
     * @param value The webpage that Azure Storage serves for requests to the root of a website or any sub-folder. For example, 'index.html'. The value is case-sensitive.
     */
    @JvmName("hrglesfiwekxxxje")
    public suspend fun indexDocument(`value`: Output<String>) {
        this.indexDocument = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jjttacmlgcmyljdg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group.
     */
    @JvmName("koixgauelhmwjogt")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
     */
    @JvmName("picjpkmhnercyucq")
    public suspend fun error404Document(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error404Document = mapped
    }

    /**
     * @param value The webpage that Azure Storage serves for requests to the root of a website or any sub-folder. For example, 'index.html'. The value is case-sensitive.
     */
    @JvmName("nvbdlyikhgrqfflo")
    public suspend fun indexDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexDocument = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("dbolxubmsrsdydpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): StorageAccountStaticWebsiteArgs = StorageAccountStaticWebsiteArgs(
        accountName = accountName,
        error404Document = error404Document,
        indexDocument = indexDocument,
        resourceGroupName = resourceGroupName,
    )
}
