@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.StorageFunctions.getBlobContainerImmutabilityPolicyPlain
import com.pulumi.azurenative.storage.StorageFunctions.getBlobContainerPlain
import com.pulumi.azurenative.storage.StorageFunctions.getBlobInventoryPolicyPlain
import com.pulumi.azurenative.storage.StorageFunctions.getBlobServicePropertiesPlain
import com.pulumi.azurenative.storage.StorageFunctions.getEncryptionScopePlain
import com.pulumi.azurenative.storage.StorageFunctions.getFileServicePropertiesPlain
import com.pulumi.azurenative.storage.StorageFunctions.getFileSharePlain
import com.pulumi.azurenative.storage.StorageFunctions.getLocalUserPlain
import com.pulumi.azurenative.storage.StorageFunctions.getManagementPolicyPlain
import com.pulumi.azurenative.storage.StorageFunctions.getObjectReplicationPolicyPlain
import com.pulumi.azurenative.storage.StorageFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.storage.StorageFunctions.getQueuePlain
import com.pulumi.azurenative.storage.StorageFunctions.getQueueServicePropertiesPlain
import com.pulumi.azurenative.storage.StorageFunctions.getStorageAccountPlain
import com.pulumi.azurenative.storage.StorageFunctions.getStorageTaskAssignmentPlain
import com.pulumi.azurenative.storage.StorageFunctions.getTablePlain
import com.pulumi.azurenative.storage.StorageFunctions.getTableServicePropertiesPlain
import com.pulumi.azurenative.storage.StorageFunctions.listLocalUserKeysPlain
import com.pulumi.azurenative.storage.StorageFunctions.listStorageAccountKeysPlain
import com.pulumi.azurenative.storage.StorageFunctions.listStorageAccountSASPlain
import com.pulumi.azurenative.storage.StorageFunctions.listStorageAccountServiceSASPlain
import com.pulumi.azurenative.storage.kotlin.enums.HttpProtocol
import com.pulumi.azurenative.storage.kotlin.enums.Permissions
import com.pulumi.azurenative.storage.kotlin.enums.Services
import com.pulumi.azurenative.storage.kotlin.enums.SignedResource
import com.pulumi.azurenative.storage.kotlin.enums.SignedResourceTypes
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobContainerImmutabilityPolicyPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobContainerImmutabilityPolicyPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobContainerPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobContainerPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobInventoryPolicyPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobInventoryPolicyPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobServicePropertiesPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetBlobServicePropertiesPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetEncryptionScopePlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetEncryptionScopePlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetFileServicePropertiesPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetFileServicePropertiesPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetFileSharePlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetFileSharePlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetLocalUserPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetLocalUserPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetManagementPolicyPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetManagementPolicyPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetObjectReplicationPolicyPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetObjectReplicationPolicyPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetQueuePlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetQueuePlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetQueueServicePropertiesPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetQueueServicePropertiesPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetStorageAccountPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetStorageAccountPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetStorageTaskAssignmentPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetStorageTaskAssignmentPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetTablePlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetTablePlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.GetTableServicePropertiesPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.GetTableServicePropertiesPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ListLocalUserKeysPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ListLocalUserKeysPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountKeysPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountSASPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountSASPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountServiceSASPlainArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ListStorageAccountServiceSASPlainArgsBuilder
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobContainerImmutabilityPolicyResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobContainerResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobInventoryPolicyResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobServicePropertiesResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetEncryptionScopeResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetFileServicePropertiesResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetFileShareResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetLocalUserResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetManagementPolicyResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetObjectReplicationPolicyResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetQueueResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetQueueServicePropertiesResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetStorageAccountResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetStorageTaskAssignmentResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetTableResult
import com.pulumi.azurenative.storage.kotlin.outputs.GetTableServicePropertiesResult
import com.pulumi.azurenative.storage.kotlin.outputs.ListLocalUserKeysResult
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountKeysResult
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountSASResult
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountServiceSASResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobContainerImmutabilityPolicyResult.Companion.toKotlin as getBlobContainerImmutabilityPolicyResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobContainerResult.Companion.toKotlin as getBlobContainerResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobInventoryPolicyResult.Companion.toKotlin as getBlobInventoryPolicyResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetBlobServicePropertiesResult.Companion.toKotlin as getBlobServicePropertiesResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetEncryptionScopeResult.Companion.toKotlin as getEncryptionScopeResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetFileServicePropertiesResult.Companion.toKotlin as getFileServicePropertiesResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetFileShareResult.Companion.toKotlin as getFileShareResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetLocalUserResult.Companion.toKotlin as getLocalUserResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetManagementPolicyResult.Companion.toKotlin as getManagementPolicyResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetObjectReplicationPolicyResult.Companion.toKotlin as getObjectReplicationPolicyResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetQueueResult.Companion.toKotlin as getQueueResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetQueueServicePropertiesResult.Companion.toKotlin as getQueueServicePropertiesResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetStorageAccountResult.Companion.toKotlin as getStorageAccountResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetStorageTaskAssignmentResult.Companion.toKotlin as getStorageTaskAssignmentResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetTableResult.Companion.toKotlin as getTableResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GetTableServicePropertiesResult.Companion.toKotlin as getTableServicePropertiesResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ListLocalUserKeysResult.Companion.toKotlin as listLocalUserKeysResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountKeysResult.Companion.toKotlin as listStorageAccountKeysResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountSASResult.Companion.toKotlin as listStorageAccountSASResultToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ListStorageAccountServiceSASResult.Companion.toKotlin as listStorageAccountServiceSASResultToKotlin

public object StorageFunctions {
    /**
     * Gets properties of a specified container.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return Properties of the blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainer(argument: GetBlobContainerPlainArgs): GetBlobContainerResult =
        getBlobContainerResultToKotlin(getBlobContainerPlain(argument.toJava()).await())

    /**
     * @see [getBlobContainer].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param containerName The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return Properties of the blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainer(
        accountName: String,
        containerName: String,
        resourceGroupName: String,
    ): GetBlobContainerResult {
        val argument = GetBlobContainerPlainArgs(
            accountName = accountName,
            containerName = containerName,
            resourceGroupName = resourceGroupName,
        )
        return getBlobContainerResultToKotlin(getBlobContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetBlobContainerPlainArgs].
     * @return Properties of the blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainer(argument: suspend GetBlobContainerPlainArgsBuilder.() -> Unit): GetBlobContainerResult {
        val builder = GetBlobContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobContainerResultToKotlin(getBlobContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the existing immutability policy along with the corresponding ETag in response headers and body.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2019-04-01, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainerImmutabilityPolicy(argument: GetBlobContainerImmutabilityPolicyPlainArgs): GetBlobContainerImmutabilityPolicyResult =
        getBlobContainerImmutabilityPolicyResultToKotlin(getBlobContainerImmutabilityPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBlobContainerImmutabilityPolicy].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param containerName The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param immutabilityPolicyName The name of the blob container immutabilityPolicy within the specified storage account. ImmutabilityPolicy Name must be 'default'
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainerImmutabilityPolicy(
        accountName: String,
        containerName: String,
        immutabilityPolicyName: String,
        resourceGroupName: String,
    ): GetBlobContainerImmutabilityPolicyResult {
        val argument = GetBlobContainerImmutabilityPolicyPlainArgs(
            accountName = accountName,
            containerName = containerName,
            immutabilityPolicyName = immutabilityPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getBlobContainerImmutabilityPolicyResultToKotlin(getBlobContainerImmutabilityPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobContainerImmutabilityPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetBlobContainerImmutabilityPolicyPlainArgs].
     * @return The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
     */
    public suspend fun getBlobContainerImmutabilityPolicy(argument: suspend GetBlobContainerImmutabilityPolicyPlainArgsBuilder.() -> Unit): GetBlobContainerImmutabilityPolicyResult {
        val builder = GetBlobContainerImmutabilityPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobContainerImmutabilityPolicyResultToKotlin(getBlobContainerImmutabilityPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the blob inventory policy associated with the specified storage account.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The storage account blob inventory policy.
     */
    public suspend fun getBlobInventoryPolicy(argument: GetBlobInventoryPolicyPlainArgs): GetBlobInventoryPolicyResult =
        getBlobInventoryPolicyResultToKotlin(getBlobInventoryPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBlobInventoryPolicy].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param blobInventoryPolicyName The name of the storage account blob inventory policy. It should always be 'default'
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The storage account blob inventory policy.
     */
    public suspend fun getBlobInventoryPolicy(
        accountName: String,
        blobInventoryPolicyName: String,
        resourceGroupName: String,
    ): GetBlobInventoryPolicyResult {
        val argument = GetBlobInventoryPolicyPlainArgs(
            accountName = accountName,
            blobInventoryPolicyName = blobInventoryPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getBlobInventoryPolicyResultToKotlin(getBlobInventoryPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobInventoryPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetBlobInventoryPolicyPlainArgs].
     * @return The storage account blob inventory policy.
     */
    public suspend fun getBlobInventoryPolicy(argument: suspend GetBlobInventoryPolicyPlainArgsBuilder.() -> Unit): GetBlobInventoryPolicyResult {
        val builder = GetBlobInventoryPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobInventoryPolicyResultToKotlin(getBlobInventoryPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of a storage account’s Blob service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The properties of a storage account’s Blob service.
     */
    public suspend fun getBlobServiceProperties(argument: GetBlobServicePropertiesPlainArgs): GetBlobServicePropertiesResult =
        getBlobServicePropertiesResultToKotlin(getBlobServicePropertiesPlain(argument.toJava()).await())

    /**
     * @see [getBlobServiceProperties].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param blobServicesName The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The properties of a storage account’s Blob service.
     */
    public suspend fun getBlobServiceProperties(
        accountName: String,
        blobServicesName: String,
        resourceGroupName: String,
    ): GetBlobServicePropertiesResult {
        val argument = GetBlobServicePropertiesPlainArgs(
            accountName = accountName,
            blobServicesName = blobServicesName,
            resourceGroupName = resourceGroupName,
        )
        return getBlobServicePropertiesResultToKotlin(getBlobServicePropertiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlobServiceProperties].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetBlobServicePropertiesPlainArgs].
     * @return The properties of a storage account’s Blob service.
     */
    public suspend fun getBlobServiceProperties(argument: suspend GetBlobServicePropertiesPlainArgsBuilder.() -> Unit): GetBlobServicePropertiesResult {
        val builder = GetBlobServicePropertiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlobServicePropertiesResultToKotlin(getBlobServicePropertiesPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties for the specified encryption scope.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The Encryption Scope resource.
     */
    public suspend fun getEncryptionScope(argument: GetEncryptionScopePlainArgs): GetEncryptionScopeResult =
        getEncryptionScopeResultToKotlin(getEncryptionScopePlain(argument.toJava()).await())

    /**
     * @see [getEncryptionScope].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The Encryption Scope resource.
     */
    public suspend fun getEncryptionScope(
        accountName: String,
        encryptionScopeName: String,
        resourceGroupName: String,
    ): GetEncryptionScopeResult {
        val argument = GetEncryptionScopePlainArgs(
            accountName = accountName,
            encryptionScopeName = encryptionScopeName,
            resourceGroupName = resourceGroupName,
        )
        return getEncryptionScopeResultToKotlin(getEncryptionScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getEncryptionScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetEncryptionScopePlainArgs].
     * @return The Encryption Scope resource.
     */
    public suspend fun getEncryptionScope(argument: suspend GetEncryptionScopePlainArgsBuilder.() -> Unit): GetEncryptionScopeResult {
        val builder = GetEncryptionScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEncryptionScopeResultToKotlin(getEncryptionScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of file services in storage accounts, including CORS (Cross-Origin Resource Sharing) rules.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The properties of File services in storage account.
     */
    public suspend fun getFileServiceProperties(argument: GetFileServicePropertiesPlainArgs): GetFileServicePropertiesResult =
        getFileServicePropertiesResultToKotlin(getFileServicePropertiesPlain(argument.toJava()).await())

    /**
     * @see [getFileServiceProperties].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param fileServicesName The name of the file Service within the specified storage account. File Service Name must be "default"
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The properties of File services in storage account.
     */
    public suspend fun getFileServiceProperties(
        accountName: String,
        fileServicesName: String,
        resourceGroupName: String,
    ): GetFileServicePropertiesResult {
        val argument = GetFileServicePropertiesPlainArgs(
            accountName = accountName,
            fileServicesName = fileServicesName,
            resourceGroupName = resourceGroupName,
        )
        return getFileServicePropertiesResultToKotlin(getFileServicePropertiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getFileServiceProperties].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetFileServicePropertiesPlainArgs].
     * @return The properties of File services in storage account.
     */
    public suspend fun getFileServiceProperties(argument: suspend GetFileServicePropertiesPlainArgsBuilder.() -> Unit): GetFileServicePropertiesResult {
        val builder = GetFileServicePropertiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileServicePropertiesResultToKotlin(getFileServicePropertiesPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets properties of a specified share.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return Properties of the file share, including Id, resource name, resource type, Etag.
     */
    public suspend fun getFileShare(argument: GetFileSharePlainArgs): GetFileShareResult =
        getFileShareResultToKotlin(getFileSharePlain(argument.toJava()).await())

    /**
     * @see [getFileShare].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should be passed as a string with delimiter ','.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param shareName The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     * @return Properties of the file share, including Id, resource name, resource type, Etag.
     */
    public suspend fun getFileShare(
        accountName: String,
        expand: String? = null,
        resourceGroupName: String,
        shareName: String,
    ): GetFileShareResult {
        val argument = GetFileSharePlainArgs(
            accountName = accountName,
            expand = expand,
            resourceGroupName = resourceGroupName,
            shareName = shareName,
        )
        return getFileShareResultToKotlin(getFileSharePlain(argument.toJava()).await())
    }

    /**
     * @see [getFileShare].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetFileSharePlainArgs].
     * @return Properties of the file share, including Id, resource name, resource type, Etag.
     */
    public suspend fun getFileShare(argument: suspend GetFileSharePlainArgsBuilder.() -> Unit): GetFileShareResult {
        val builder = GetFileSharePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFileShareResultToKotlin(getFileSharePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the local user of the storage account by username.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The local user associated with the storage accounts.
     */
    public suspend fun getLocalUser(argument: GetLocalUserPlainArgs): GetLocalUserResult =
        getLocalUserResultToKotlin(getLocalUserPlain(argument.toJava()).await())

    /**
     * @see [getLocalUser].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param username The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
     * @return The local user associated with the storage accounts.
     */
    public suspend fun getLocalUser(
        accountName: String,
        resourceGroupName: String,
        username: String,
    ): GetLocalUserResult {
        val argument = GetLocalUserPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            username = username,
        )
        return getLocalUserResultToKotlin(getLocalUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetLocalUserPlainArgs].
     * @return The local user associated with the storage accounts.
     */
    public suspend fun getLocalUser(argument: suspend GetLocalUserPlainArgsBuilder.() -> Unit): GetLocalUserResult {
        val builder = GetLocalUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalUserResultToKotlin(getLocalUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the managementpolicy associated with the specified storage account.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2018-03-01-preview, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The Get Storage Account ManagementPolicies operation response.
     */
    public suspend fun getManagementPolicy(argument: GetManagementPolicyPlainArgs): GetManagementPolicyResult =
        getManagementPolicyResultToKotlin(getManagementPolicyPlain(argument.toJava()).await())

    /**
     * @see [getManagementPolicy].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param managementPolicyName The name of the Storage Account Management Policy. It should always be 'default'
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The Get Storage Account ManagementPolicies operation response.
     */
    public suspend fun getManagementPolicy(
        accountName: String,
        managementPolicyName: String,
        resourceGroupName: String,
    ): GetManagementPolicyResult {
        val argument = GetManagementPolicyPlainArgs(
            accountName = accountName,
            managementPolicyName = managementPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getManagementPolicyResultToKotlin(getManagementPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetManagementPolicyPlainArgs].
     * @return The Get Storage Account ManagementPolicies operation response.
     */
    public suspend fun getManagementPolicy(argument: suspend GetManagementPolicyPlainArgsBuilder.() -> Unit): GetManagementPolicyResult {
        val builder = GetManagementPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementPolicyResultToKotlin(getManagementPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the object replication policy of the storage account by policy ID.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The replication policy between two storage accounts. Multiple rules can be defined in one policy.
     */
    public suspend fun getObjectReplicationPolicy(argument: GetObjectReplicationPolicyPlainArgs): GetObjectReplicationPolicyResult =
        getObjectReplicationPolicyResultToKotlin(getObjectReplicationPolicyPlain(argument.toJava()).await())

    /**
     * @see [getObjectReplicationPolicy].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The replication policy between two storage accounts. Multiple rules can be defined in one policy.
     */
    public suspend fun getObjectReplicationPolicy(
        accountName: String,
        objectReplicationPolicyId: String,
        resourceGroupName: String,
    ): GetObjectReplicationPolicyResult {
        val argument = GetObjectReplicationPolicyPlainArgs(
            accountName = accountName,
            objectReplicationPolicyId = objectReplicationPolicyId,
            resourceGroupName = resourceGroupName,
        )
        return getObjectReplicationPolicyResultToKotlin(getObjectReplicationPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getObjectReplicationPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetObjectReplicationPolicyPlainArgs].
     * @return The replication policy between two storage accounts. Multiple rules can be defined in one policy.
     */
    public suspend fun getObjectReplicationPolicy(argument: suspend GetObjectReplicationPolicyPlainArgsBuilder.() -> Unit): GetObjectReplicationPolicyResult {
        val builder = GetObjectReplicationPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObjectReplicationPolicyResultToKotlin(getObjectReplicationPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the storage account.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the queue with the specified queue name, under the specified account if it exists.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return null
     */
    public suspend fun getQueue(argument: GetQueuePlainArgs): GetQueueResult =
        getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())

    /**
     * @see [getQueue].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param queueName A queue name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of lowercase alphanumeric and dash(-) characters only, it should begin and end with an alphanumeric character and it cannot have two consecutive dash(-) characters.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return null
     */
    public suspend fun getQueue(
        accountName: String,
        queueName: String,
        resourceGroupName: String,
    ): GetQueueResult {
        val argument = GetQueuePlainArgs(
            accountName = accountName,
            queueName = queueName,
            resourceGroupName = resourceGroupName,
        )
        return getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetQueuePlainArgs].
     * @return null
     */
    public suspend fun getQueue(argument: suspend GetQueuePlainArgsBuilder.() -> Unit): GetQueueResult {
        val builder = GetQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueResultToKotlin(getQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of a storage account’s Queue service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The properties of a storage account’s Queue service.
     */
    public suspend fun getQueueServiceProperties(argument: GetQueueServicePropertiesPlainArgs): GetQueueServicePropertiesResult =
        getQueueServicePropertiesResultToKotlin(getQueueServicePropertiesPlain(argument.toJava()).await())

    /**
     * @see [getQueueServiceProperties].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param queueServiceName The name of the Queue Service within the specified storage account. Queue Service Name must be 'default'
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The properties of a storage account’s Queue service.
     */
    public suspend fun getQueueServiceProperties(
        accountName: String,
        queueServiceName: String,
        resourceGroupName: String,
    ): GetQueueServicePropertiesResult {
        val argument = GetQueueServicePropertiesPlainArgs(
            accountName = accountName,
            queueServiceName = queueServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getQueueServicePropertiesResultToKotlin(getQueueServicePropertiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueueServiceProperties].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetQueueServicePropertiesPlainArgs].
     * @return The properties of a storage account’s Queue service.
     */
    public suspend fun getQueueServiceProperties(argument: suspend GetQueueServicePropertiesPlainArgsBuilder.() -> Unit): GetQueueServicePropertiesResult {
        val builder = GetQueueServicePropertiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueServicePropertiesResultToKotlin(getQueueServicePropertiesPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the properties for the specified storage account including but not limited to name, SKU name, location, and account status. The ListKeys operation should be used to retrieve storage keys.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2015-05-01-preview, 2015-06-15, 2018-11-01, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The storage account.
     */
    public suspend fun getStorageAccount(argument: GetStorageAccountPlainArgs): GetStorageAccountResult =
        getStorageAccountResultToKotlin(getStorageAccountPlain(argument.toJava()).await())

    /**
     * @see [getStorageAccount].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand May be used to expand the properties within account's properties. By default, data is not included when fetching properties. Currently we only support geoReplicationStats and blobRestoreStatus.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The storage account.
     */
    public suspend fun getStorageAccount(
        accountName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): GetStorageAccountResult {
        val argument = GetStorageAccountPlainArgs(
            accountName = accountName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return getStorageAccountResultToKotlin(getStorageAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetStorageAccountPlainArgs].
     * @return The storage account.
     */
    public suspend fun getStorageAccount(argument: suspend GetStorageAccountPlainArgsBuilder.() -> Unit): GetStorageAccountResult {
        val builder = GetStorageAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageAccountResultToKotlin(getStorageAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the storage task assignment properties
     * Azure REST API version: 2023-05-01.
     * @param argument null
     * @return The storage task assignment.
     */
    public suspend fun getStorageTaskAssignment(argument: GetStorageTaskAssignmentPlainArgs): GetStorageTaskAssignmentResult =
        getStorageTaskAssignmentResultToKotlin(getStorageTaskAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getStorageTaskAssignment].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageTaskAssignmentName The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @return The storage task assignment.
     */
    public suspend fun getStorageTaskAssignment(
        accountName: String,
        resourceGroupName: String,
        storageTaskAssignmentName: String,
    ): GetStorageTaskAssignmentResult {
        val argument = GetStorageTaskAssignmentPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            storageTaskAssignmentName = storageTaskAssignmentName,
        )
        return getStorageTaskAssignmentResultToKotlin(getStorageTaskAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageTaskAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetStorageTaskAssignmentPlainArgs].
     * @return The storage task assignment.
     */
    public suspend fun getStorageTaskAssignment(argument: suspend GetStorageTaskAssignmentPlainArgsBuilder.() -> Unit): GetStorageTaskAssignmentResult {
        val builder = GetStorageTaskAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageTaskAssignmentResultToKotlin(getStorageTaskAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the table with the specified table name, under the specified account if it exists.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return Properties of the table, including Id, resource name, resource type.
     */
    public suspend fun getTable(argument: GetTablePlainArgs): GetTableResult =
        getTableResultToKotlin(getTablePlain(argument.toJava()).await())

    /**
     * @see [getTable].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     * @return Properties of the table, including Id, resource name, resource type.
     */
    public suspend fun getTable(
        accountName: String,
        resourceGroupName: String,
        tableName: String,
    ): GetTableResult {
        val argument = GetTablePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            tableName = tableName,
        )
        return getTableResultToKotlin(getTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getTable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetTablePlainArgs].
     * @return Properties of the table, including Id, resource name, resource type.
     */
    public suspend fun getTable(argument: suspend GetTablePlainArgsBuilder.() -> Unit): GetTableResult {
        val builder = GetTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableResultToKotlin(getTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of a storage account’s Table service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The properties of a storage account’s Table service.
     */
    public suspend fun getTableServiceProperties(argument: GetTableServicePropertiesPlainArgs): GetTableServicePropertiesResult =
        getTableServicePropertiesResultToKotlin(getTableServicePropertiesPlain(argument.toJava()).await())

    /**
     * @see [getTableServiceProperties].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param tableServiceName The name of the Table Service within the specified storage account. Table Service Name must be 'default'
     * @return The properties of a storage account’s Table service.
     */
    public suspend fun getTableServiceProperties(
        accountName: String,
        resourceGroupName: String,
        tableServiceName: String,
    ): GetTableServicePropertiesResult {
        val argument = GetTableServicePropertiesPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            tableServiceName = tableServiceName,
        )
        return getTableServicePropertiesResultToKotlin(getTableServicePropertiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTableServiceProperties].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;GetTableServicePropertiesPlainArgs].
     * @return The properties of a storage account’s Table service.
     */
    public suspend fun getTableServiceProperties(argument: suspend GetTableServicePropertiesPlainArgsBuilder.() -> Unit): GetTableServicePropertiesResult {
        val builder = GetTableServicePropertiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableServicePropertiesResultToKotlin(getTableServicePropertiesPlain(builtArgument.toJava()).await())
    }

    /**
     * List SSH authorized keys and shared key of the local user.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The Storage Account Local User keys.
     */
    public suspend fun listLocalUserKeys(argument: ListLocalUserKeysPlainArgs): ListLocalUserKeysResult =
        listLocalUserKeysResultToKotlin(listLocalUserKeysPlain(argument.toJava()).await())

    /**
     * @see [listLocalUserKeys].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param username The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
     * @return The Storage Account Local User keys.
     */
    public suspend fun listLocalUserKeys(
        accountName: String,
        resourceGroupName: String,
        username: String,
    ): ListLocalUserKeysResult {
        val argument = ListLocalUserKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            username = username,
        )
        return listLocalUserKeysResultToKotlin(listLocalUserKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listLocalUserKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;ListLocalUserKeysPlainArgs].
     * @return The Storage Account Local User keys.
     */
    public suspend fun listLocalUserKeys(argument: suspend ListLocalUserKeysPlainArgsBuilder.() -> Unit): ListLocalUserKeysResult {
        val builder = ListLocalUserKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listLocalUserKeysResultToKotlin(listLocalUserKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the access keys or Kerberos keys (if active directory enabled) for the specified storage account.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2015-05-01-preview, 2015-06-15, 2018-11-01, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The response from the ListKeys operation.
     */
    public suspend fun listStorageAccountKeys(argument: ListStorageAccountKeysPlainArgs): ListStorageAccountKeysResult =
        listStorageAccountKeysResultToKotlin(listStorageAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listStorageAccountKeys].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param expand Specifies type of the key to be listed. Possible value is kerb.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @return The response from the ListKeys operation.
     */
    public suspend fun listStorageAccountKeys(
        accountName: String,
        expand: String? = null,
        resourceGroupName: String,
    ): ListStorageAccountKeysResult {
        val argument = ListStorageAccountKeysPlainArgs(
            accountName = accountName,
            expand = expand,
            resourceGroupName = resourceGroupName,
        )
        return listStorageAccountKeysResultToKotlin(listStorageAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listStorageAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;ListStorageAccountKeysPlainArgs].
     * @return The response from the ListKeys operation.
     */
    public suspend fun listStorageAccountKeys(argument: suspend ListStorageAccountKeysPlainArgsBuilder.() -> Unit): ListStorageAccountKeysResult {
        val builder = ListStorageAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStorageAccountKeysResultToKotlin(listStorageAccountKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List SAS credentials of a storage account.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2018-11-01, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The List SAS credentials operation response.
     */
    public suspend fun listStorageAccountSAS(argument: ListStorageAccountSASPlainArgs): ListStorageAccountSASResult =
        listStorageAccountSASResultToKotlin(listStorageAccountSASPlain(argument.toJava()).await())

    /**
     * @see [listStorageAccountSAS].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param iPAddressOrRange An IP address or a range of IP addresses from which to accept requests.
     * @param keyToSign The key to sign the account SAS token with.
     * @param permissions The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     * @param protocols The protocol permitted for a request made with the account SAS.
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param resourceTypes The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
     * @param services The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
     * @param sharedAccessExpiryTime The time at which the shared access signature becomes invalid.
     * @param sharedAccessStartTime The time at which the SAS becomes valid.
     * @return The List SAS credentials operation response.
     */
    public suspend fun listStorageAccountSAS(
        accountName: String,
        iPAddressOrRange: String? = null,
        keyToSign: String? = null,
        permissions: Either<String, Permissions>,
        protocols: HttpProtocol? = null,
        resourceGroupName: String,
        resourceTypes: Either<String, SignedResourceTypes>,
        services: Either<String, Services>,
        sharedAccessExpiryTime: String,
        sharedAccessStartTime: String? = null,
    ): ListStorageAccountSASResult {
        val argument = ListStorageAccountSASPlainArgs(
            accountName = accountName,
            iPAddressOrRange = iPAddressOrRange,
            keyToSign = keyToSign,
            permissions = permissions,
            protocols = protocols,
            resourceGroupName = resourceGroupName,
            resourceTypes = resourceTypes,
            services = services,
            sharedAccessExpiryTime = sharedAccessExpiryTime,
            sharedAccessStartTime = sharedAccessStartTime,
        )
        return listStorageAccountSASResultToKotlin(listStorageAccountSASPlain(argument.toJava()).await())
    }

    /**
     * @see [listStorageAccountSAS].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;ListStorageAccountSASPlainArgs].
     * @return The List SAS credentials operation response.
     */
    public suspend fun listStorageAccountSAS(argument: suspend ListStorageAccountSASPlainArgsBuilder.() -> Unit): ListStorageAccountSASResult {
        val builder = ListStorageAccountSASPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStorageAccountSASResultToKotlin(listStorageAccountSASPlain(builtArgument.toJava()).await())
    }

    /**
     * List service SAS credentials of a specific resource.
     * Azure REST API version: 2022-09-01.
     * Other available API versions: 2018-11-01, 2023-01-01, 2023-04-01, 2023-05-01.
     * @param argument null
     * @return The List service SAS credentials operation response.
     */
    public suspend fun listStorageAccountServiceSAS(argument: ListStorageAccountServiceSASPlainArgs): ListStorageAccountServiceSASResult =
        listStorageAccountServiceSASResultToKotlin(listStorageAccountServiceSASPlain(argument.toJava()).await())

    /**
     * @see [listStorageAccountServiceSAS].
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param cacheControl The response header override for cache control.
     * @param canonicalizedResource The canonical path to the signed resource.
     * @param contentDisposition The response header override for content disposition.
     * @param contentEncoding The response header override for content encoding.
     * @param contentLanguage The response header override for content language.
     * @param contentType The response header override for content type.
     * @param iPAddressOrRange An IP address or a range of IP addresses from which to accept requests.
     * @param identifier A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or table.
     * @param keyToSign The key to sign the account SAS token with.
     * @param partitionKeyEnd The end of partition key.
     * @param partitionKeyStart The start of partition key.
     * @param permissions The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
     * @param protocols The protocol permitted for a request made with the account SAS.
     * @param resource The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param rowKeyEnd The end of row key.
     * @param rowKeyStart The start of row key.
     * @param sharedAccessExpiryTime The time at which the shared access signature becomes invalid.
     * @param sharedAccessStartTime The time at which the SAS becomes valid.
     * @return The List service SAS credentials operation response.
     */
    public suspend fun listStorageAccountServiceSAS(
        accountName: String,
        cacheControl: String? = null,
        canonicalizedResource: String,
        contentDisposition: String? = null,
        contentEncoding: String? = null,
        contentLanguage: String? = null,
        contentType: String? = null,
        iPAddressOrRange: String? = null,
        identifier: String? = null,
        keyToSign: String? = null,
        partitionKeyEnd: String? = null,
        partitionKeyStart: String? = null,
        permissions: Either<String, Permissions>? = null,
        protocols: HttpProtocol? = null,
        resource: Either<String, SignedResource>? = null,
        resourceGroupName: String,
        rowKeyEnd: String? = null,
        rowKeyStart: String? = null,
        sharedAccessExpiryTime: String? = null,
        sharedAccessStartTime: String? = null,
    ): ListStorageAccountServiceSASResult {
        val argument = ListStorageAccountServiceSASPlainArgs(
            accountName = accountName,
            cacheControl = cacheControl,
            canonicalizedResource = canonicalizedResource,
            contentDisposition = contentDisposition,
            contentEncoding = contentEncoding,
            contentLanguage = contentLanguage,
            contentType = contentType,
            iPAddressOrRange = iPAddressOrRange,
            identifier = identifier,
            keyToSign = keyToSign,
            partitionKeyEnd = partitionKeyEnd,
            partitionKeyStart = partitionKeyStart,
            permissions = permissions,
            protocols = protocols,
            resource = resource,
            resourceGroupName = resourceGroupName,
            rowKeyEnd = rowKeyEnd,
            rowKeyStart = rowKeyStart,
            sharedAccessExpiryTime = sharedAccessExpiryTime,
            sharedAccessStartTime = sharedAccessStartTime,
        )
        return listStorageAccountServiceSASResultToKotlin(listStorageAccountServiceSASPlain(argument.toJava()).await())
    }

    /**
     * @see [listStorageAccountServiceSAS].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;storage&#46;kotlin&#46;inputs&#46;ListStorageAccountServiceSASPlainArgs].
     * @return The List service SAS credentials operation response.
     */
    public suspend fun listStorageAccountServiceSAS(argument: suspend ListStorageAccountServiceSASPlainArgsBuilder.() -> Unit): ListStorageAccountServiceSASResult {
        val builder = ListStorageAccountServiceSASPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStorageAccountServiceSASResultToKotlin(listStorageAccountServiceSASPlain(builtArgument.toJava()).await())
    }
}
