@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.StorageTaskAssignmentPropertiesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storage.kotlin.outputs.StorageTaskAssignmentPropertiesResponse.Companion.toKotlin as storageTaskAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageTaskAssignment].
 */
@PulumiTagMarker
public class StorageTaskAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageTaskAssignmentArgs = StorageTaskAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageTaskAssignmentArgsBuilder.() -> Unit) {
        val builder = StorageTaskAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageTaskAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.storage.StorageTaskAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageTaskAssignment(builtJavaResource)
    }
}

/**
 * The storage task assignment.
 * Azure REST API version: 2023-05-01.
 * ## Example Usage
 * ### PutStorageTaskAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTaskAssignment = new AzureNative.Storage.StorageTaskAssignment("storageTaskAssignment", new()
 *     {
 *         AccountName = "sto4445",
 *         Properties = new AzureNative.Storage.Inputs.StorageTaskAssignmentPropertiesArgs
 *         {
 *             Description = "My Storage task assignment",
 *             Enabled = true,
 *             ExecutionContext = new AzureNative.Storage.Inputs.StorageTaskAssignmentExecutionContextArgs
 *             {
 *                 Target = new AzureNative.Storage.Inputs.ExecutionTargetArgs
 *                 {
 *                     ExcludePrefix = new() { },
 *                     Prefix = new[]
 *                     {
 *                         "prefix1",
 *                         "prefix2",
 *                     },
 *                 },
 *                 Trigger = new AzureNative.Storage.Inputs.ExecutionTriggerArgs
 *                 {
 *                     Parameters = new AzureNative.Storage.Inputs.TriggerParametersArgs
 *                     {
 *                         StartOn = "2022-11-15T21:52:47.8145095Z",
 *                     },
 *                     Type = AzureNative.Storage.TriggerType.RunOnce,
 *                 },
 *             },
 *             Report = new AzureNative.Storage.Inputs.StorageTaskAssignmentReportArgs
 *             {
 *                 Prefix = "container1",
 *             },
 *             TaskId = "/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1",
 *         },
 *         ResourceGroupName = "res4228",
 *         StorageTaskAssignmentName = "myassignment1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageTaskAssignment(ctx, "storageTaskAssignment", &storage.StorageTaskAssignmentArgs{
 * 			AccountName: pulumi.String("sto4445"),
 * 			Properties: &storage.StorageTaskAssignmentPropertiesArgs{
 * 				Description: pulumi.String("My Storage task assignment"),
 * 				Enabled:     pulumi.Bool(true),
 * 				ExecutionContext: &storage.StorageTaskAssignmentExecutionContextArgs{
 * 					Target: &storage.ExecutionTargetArgs{
 * 						ExcludePrefix: pulumi.StringArray{},
 * 						Prefix: pulumi.StringArray{
 * 							pulumi.String("prefix1"),
 * 							pulumi.String("prefix2"),
 * 						},
 * 					},
 * 					Trigger: &storage.ExecutionTriggerArgs{
 * 						Parameters: &storage.TriggerParametersArgs{
 * 							StartOn: pulumi.String("2022-11-15T21:52:47.8145095Z"),
 * 						},
 * 						Type: storage.TriggerTypeRunOnce,
 * 					},
 * 				},
 * 				Report: &storage.StorageTaskAssignmentReportArgs{
 * 					Prefix: pulumi.String("container1"),
 * 				},
 * 				TaskId: pulumi.String("/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("res4228"),
 * 			StorageTaskAssignmentName: pulumi.String("myassignment1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageTaskAssignment;
 * import com.pulumi.azurenative.storage.StorageTaskAssignmentArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs;
 * import com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs;
 * import com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs;
 * import com.pulumi.azurenative.storage.inputs.TriggerParametersArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTaskAssignment = new StorageTaskAssignment("storageTaskAssignment", StorageTaskAssignmentArgs.builder()
 *             .accountName("sto4445")
 *             .properties(StorageTaskAssignmentPropertiesArgs.builder()
 *                 .description("My Storage task assignment")
 *                 .enabled(true)
 *                 .executionContext(StorageTaskAssignmentExecutionContextArgs.builder()
 *                     .target(ExecutionTargetArgs.builder()
 *                         .excludePrefix()
 *                         .prefix(
 *                             "prefix1",
 *                             "prefix2")
 *                         .build())
 *                     .trigger(ExecutionTriggerArgs.builder()
 *                         .parameters(TriggerParametersArgs.builder()
 *                             .startOn("2022-11-15T21:52:47.8145095Z")
 *                             .build())
 *                         .type("RunOnce")
 *                         .build())
 *                     .build())
 *                 .report(StorageTaskAssignmentReportArgs.builder()
 *                     .prefix("container1")
 *                     .build())
 *                 .taskId("/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1")
 *                 .build())
 *             .resourceGroupName("res4228")
 *             .storageTaskAssignmentName("myassignment1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageTaskAssignment myassignment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}
 * ```
 */
public class StorageTaskAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.StorageTaskAssignment,
) : KotlinCustomResource(javaResource, StorageTaskAssignmentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the storage task assignment.
     */
    public val properties: Output<StorageTaskAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                storageTaskAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageTaskAssignmentMapper : ResourceMapper<StorageTaskAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.StorageTaskAssignment::class == javaResource::class

    override fun map(javaResource: Resource): StorageTaskAssignment =
        StorageTaskAssignment(javaResource as com.pulumi.azurenative.storage.StorageTaskAssignment)
}

/**
 * @see [StorageTaskAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageTaskAssignment].
 */
public suspend fun storageTaskAssignment(
    name: String,
    block: suspend StorageTaskAssignmentResourceBuilder.() -> Unit,
): StorageTaskAssignment {
    val builder = StorageTaskAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageTaskAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageTaskAssignment(name: String): StorageTaskAssignment {
    val builder = StorageTaskAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
