@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.StorageTaskAssignmentArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.StorageTaskAssignmentPropertiesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.StorageTaskAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage task assignment.
 * Azure REST API version: 2023-05-01.
 * ## Example Usage
 * ### PutStorageTaskAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTaskAssignment = new AzureNative.Storage.StorageTaskAssignment("storageTaskAssignment", new()
 *     {
 *         AccountName = "sto4445",
 *         Properties = new AzureNative.Storage.Inputs.StorageTaskAssignmentPropertiesArgs
 *         {
 *             Description = "My Storage task assignment",
 *             Enabled = true,
 *             ExecutionContext = new AzureNative.Storage.Inputs.StorageTaskAssignmentExecutionContextArgs
 *             {
 *                 Target = new AzureNative.Storage.Inputs.ExecutionTargetArgs
 *                 {
 *                     ExcludePrefix = new() { },
 *                     Prefix = new[]
 *                     {
 *                         "prefix1",
 *                         "prefix2",
 *                     },
 *                 },
 *                 Trigger = new AzureNative.Storage.Inputs.ExecutionTriggerArgs
 *                 {
 *                     Parameters = new AzureNative.Storage.Inputs.TriggerParametersArgs
 *                     {
 *                         StartOn = "2022-11-15T21:52:47.8145095Z",
 *                     },
 *                     Type = AzureNative.Storage.TriggerType.RunOnce,
 *                 },
 *             },
 *             Report = new AzureNative.Storage.Inputs.StorageTaskAssignmentReportArgs
 *             {
 *                 Prefix = "container1",
 *             },
 *             TaskId = "/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1",
 *         },
 *         ResourceGroupName = "res4228",
 *         StorageTaskAssignmentName = "myassignment1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageTaskAssignment(ctx, "storageTaskAssignment", &storage.StorageTaskAssignmentArgs{
 * 			AccountName: pulumi.String("sto4445"),
 * 			Properties: &storage.StorageTaskAssignmentPropertiesArgs{
 * 				Description: pulumi.String("My Storage task assignment"),
 * 				Enabled:     pulumi.Bool(true),
 * 				ExecutionContext: &storage.StorageTaskAssignmentExecutionContextArgs{
 * 					Target: &storage.ExecutionTargetArgs{
 * 						ExcludePrefix: pulumi.StringArray{},
 * 						Prefix: pulumi.StringArray{
 * 							pulumi.String("prefix1"),
 * 							pulumi.String("prefix2"),
 * 						},
 * 					},
 * 					Trigger: &storage.ExecutionTriggerArgs{
 * 						Parameters: &storage.TriggerParametersArgs{
 * 							StartOn: pulumi.String("2022-11-15T21:52:47.8145095Z"),
 * 						},
 * 						Type: storage.TriggerTypeRunOnce,
 * 					},
 * 				},
 * 				Report: &storage.StorageTaskAssignmentReportArgs{
 * 					Prefix: pulumi.String("container1"),
 * 				},
 * 				TaskId: pulumi.String("/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("res4228"),
 * 			StorageTaskAssignmentName: pulumi.String("myassignment1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageTaskAssignment;
 * import com.pulumi.azurenative.storage.StorageTaskAssignmentArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentExecutionContextArgs;
 * import com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs;
 * import com.pulumi.azurenative.storage.inputs.ExecutionTriggerArgs;
 * import com.pulumi.azurenative.storage.inputs.TriggerParametersArgs;
 * import com.pulumi.azurenative.storage.inputs.StorageTaskAssignmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTaskAssignment = new StorageTaskAssignment("storageTaskAssignment", StorageTaskAssignmentArgs.builder()
 *             .accountName("sto4445")
 *             .properties(StorageTaskAssignmentPropertiesArgs.builder()
 *                 .description("My Storage task assignment")
 *                 .enabled(true)
 *                 .executionContext(StorageTaskAssignmentExecutionContextArgs.builder()
 *                     .target(ExecutionTargetArgs.builder()
 *                         .excludePrefix()
 *                         .prefix(
 *                             "prefix1",
 *                             "prefix2")
 *                         .build())
 *                     .trigger(ExecutionTriggerArgs.builder()
 *                         .parameters(TriggerParametersArgs.builder()
 *                             .startOn("2022-11-15T21:52:47.8145095Z")
 *                             .build())
 *                         .type("RunOnce")
 *                         .build())
 *                     .build())
 *                 .report(StorageTaskAssignmentReportArgs.builder()
 *                     .prefix("container1")
 *                     .build())
 *                 .taskId("/subscriptions/1f31ba14-ce16-4281-b9b4-3e78da6e1616/resourceGroups/res4228/providers/Microsoft.StorageActions/storageTasks/mytask1")
 *                 .build())
 *             .resourceGroupName("res4228")
 *             .storageTaskAssignmentName("myassignment1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageTaskAssignment myassignment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/storageTaskAssignments/{storageTaskAssignmentName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property properties Properties of the storage task assignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageTaskAssignmentName The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 */
public data class StorageTaskAssignmentArgs(
    public val accountName: Output<String>? = null,
    public val properties: Output<StorageTaskAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageTaskAssignmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.StorageTaskAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.StorageTaskAssignmentArgs =
        com.pulumi.azurenative.storage.StorageTaskAssignmentArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageTaskAssignmentName(storageTaskAssignmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageTaskAssignmentArgs].
 */
@PulumiTagMarker
public class StorageTaskAssignmentArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var properties: Output<StorageTaskAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageTaskAssignmentName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("bxufxtvwpapgrjvy")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Properties of the storage task assignment.
     */
    @JvmName("yfjetrwtrihjwbky")
    public suspend fun properties(`value`: Output<StorageTaskAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yenkolrvrboybiey")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("qicrghgawcgpaqcn")
    public suspend fun storageTaskAssignmentName(`value`: Output<String>) {
        this.storageTaskAssignmentName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("biftldshklrjootc")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Properties of the storage task assignment.
     */
    @JvmName("emqrbybkjdnxqcse")
    public suspend fun properties(`value`: StorageTaskAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the storage task assignment.
     */
    @JvmName("pdqiegeoxevgacvt")
    public suspend fun properties(argument: suspend StorageTaskAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = StorageTaskAssignmentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oihlwvfcdtewvnto")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage task assignment within the specified resource group. Storage task assignment names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pnkuostotdslistm")
    public suspend fun storageTaskAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTaskAssignmentName = mapped
    }

    internal fun build(): StorageTaskAssignmentArgs = StorageTaskAssignmentArgs(
        accountName = accountName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        storageTaskAssignmentName = storageTaskAssignmentName,
    )
}
