@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.TableSignedIdentifierResponse
import com.pulumi.azurenative.storage.kotlin.outputs.TableSignedIdentifierResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Table].
 */
@PulumiTagMarker
public class TableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableArgs = TableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableArgsBuilder.() -> Unit) {
        val builder = TableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Table {
        val builtJavaResource = com.pulumi.azurenative.storage.Table(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Table(builtJavaResource)
    }
}

/**
 * Properties of the table, including Id, resource name, resource type.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01, 2023-05-01.
 * ## Example Usage
 * ### TableOperationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.Storage.Table("table", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         TableName = "table6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTable(ctx, "table", &storage.TableArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			TableName:         pulumi.String("table6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Table;
 * import com.pulumi.azurenative.storage.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .tableName("table6185")
 *             .build());
 *     }
 * }
 * ```
 * ### TableOperationPutOrPatchAcls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.Storage.Table("table", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         SignedIdentifiers = new[]
 *         {
 *             new AzureNative.Storage.Inputs.TableSignedIdentifierArgs
 *             {
 *                 AccessPolicy = new AzureNative.Storage.Inputs.TableAccessPolicyArgs
 *                 {
 *                     ExpiryTime = "2022-03-20T08:49:37.0000000Z",
 *                     Permission = "raud",
 *                     StartTime = "2022-03-17T08:49:37.0000000Z",
 *                 },
 *                 Id = "MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI",
 *             },
 *             new AzureNative.Storage.Inputs.TableSignedIdentifierArgs
 *             {
 *                 AccessPolicy = new AzureNative.Storage.Inputs.TableAccessPolicyArgs
 *                 {
 *                     ExpiryTime = "2022-03-20T08:49:37.0000000Z",
 *                     Permission = "rad",
 *                     StartTime = "2022-03-17T08:49:37.0000000Z",
 *                 },
 *                 Id = "PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI",
 *             },
 *         },
 *         TableName = "table6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTable(ctx, "table", &storage.TableArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			SignedIdentifiers: storage.TableSignedIdentifierArray{
 * 				&storage.TableSignedIdentifierArgs{
 * 					AccessPolicy: &storage.TableAccessPolicyArgs{
 * 						ExpiryTime: pulumi.String("2022-03-20T08:49:37.0000000Z"),
 * 						Permission: pulumi.String("raud"),
 * 						StartTime:  pulumi.String("2022-03-17T08:49:37.0000000Z"),
 * 					},
 * 					Id: pulumi.String("MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI"),
 * 				},
 * 				&storage.TableSignedIdentifierArgs{
 * 					AccessPolicy: &storage.TableAccessPolicyArgs{
 * 						ExpiryTime: pulumi.String("2022-03-20T08:49:37.0000000Z"),
 * 						Permission: pulumi.String("rad"),
 * 						StartTime:  pulumi.String("2022-03-17T08:49:37.0000000Z"),
 * 					},
 * 					Id: pulumi.String("PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI"),
 * 				},
 * 			},
 * 			TableName: pulumi.String("table6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Table;
 * import com.pulumi.azurenative.storage.TableArgs;
 * import com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs;
 * import com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .signedIdentifiers(
 *                 TableSignedIdentifierArgs.builder()
 *                     .accessPolicy(TableAccessPolicyArgs.builder()
 *                         .expiryTime("2022-03-20T08:49:37.0000000Z")
 *                         .permission("raud")
 *                         .startTime("2022-03-17T08:49:37.0000000Z")
 *                         .build())
 *                     .id("MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI")
 *                     .build(),
 *                 TableSignedIdentifierArgs.builder()
 *                     .accessPolicy(TableAccessPolicyArgs.builder()
 *                         .expiryTime("2022-03-20T08:49:37.0000000Z")
 *                         .permission("rad")
 *                         .startTime("2022-03-17T08:49:37.0000000Z")
 *                         .build())
 *                     .id("PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI")
 *                     .build())
 *             .tableName("table6185")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Table table6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/default/tables/{tableName}
 * ```
 */
public class Table internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.Table,
) : KotlinCustomResource(javaResource, TableMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of stored access policies specified on the table.
     */
    public val signedIdentifiers: Output<List<TableSignedIdentifierResponse>>?
        get() = javaResource.signedIdentifiers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Table name under the specified account
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TableMapper : ResourceMapper<Table> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.Table::class == javaResource::class

    override fun map(javaResource: Resource): Table = Table(
        javaResource as
            com.pulumi.azurenative.storage.Table,
    )
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Table].
 */
public suspend fun table(name: String, block: suspend TableResourceBuilder.() -> Unit): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 */
public fun table(name: String): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    return builder.build()
}
