@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the Active Directory account type for Azure Storage.
 */
public enum class AccountType(
    public val javaValue: com.pulumi.azurenative.storage.enums.AccountType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.AccountType> {
    User(com.pulumi.azurenative.storage.enums.AccountType.User),
    Computer(com.pulumi.azurenative.storage.enums.AccountType.Computer),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.AccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.AccountType): AccountType =
            AccountType.values().first { it.javaValue == javaType }
    }
}
