@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Default share permission for users using Kerberos authentication if RBAC role is not assigned.
 */
public enum class DefaultSharePermission(
    public val javaValue: com.pulumi.azurenative.storage.enums.DefaultSharePermission,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.DefaultSharePermission> {
    None(com.pulumi.azurenative.storage.enums.DefaultSharePermission.None),
    StorageFileDataSmbShareReader(com.pulumi.azurenative.storage.enums.DefaultSharePermission.StorageFileDataSmbShareReader),
    StorageFileDataSmbShareContributor(com.pulumi.azurenative.storage.enums.DefaultSharePermission.StorageFileDataSmbShareContributor),
    StorageFileDataSmbShareElevatedContributor(com.pulumi.azurenative.storage.enums.DefaultSharePermission.StorageFileDataSmbShareElevatedContributor),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.DefaultSharePermission = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.DefaultSharePermission): DefaultSharePermission = DefaultSharePermission.values().first { it.javaValue == javaType }
    }
}
