@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates the directory service used. Note that this enum may be extended in the future.
 */
public enum class DirectoryServiceOptions(
    public val javaValue: com.pulumi.azurenative.storage.enums.DirectoryServiceOptions,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.DirectoryServiceOptions> {
    None(com.pulumi.azurenative.storage.enums.DirectoryServiceOptions.None),
    AADDS(com.pulumi.azurenative.storage.enums.DirectoryServiceOptions.AADDS),
    AD(com.pulumi.azurenative.storage.enums.DirectoryServiceOptions.AD),
    AADKERB(com.pulumi.azurenative.storage.enums.DirectoryServiceOptions.AADKERB),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.DirectoryServiceOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.DirectoryServiceOptions): DirectoryServiceOptions =
            DirectoryServiceOptions.values().first { it.javaValue == javaType }
    }
}
