@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
 */
public enum class DnsEndpointType(
    public val javaValue: com.pulumi.azurenative.storage.enums.DnsEndpointType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.DnsEndpointType> {
    Standard(com.pulumi.azurenative.storage.enums.DnsEndpointType.Standard),
    AzureDnsZone(com.pulumi.azurenative.storage.enums.DnsEndpointType.AzureDnsZone),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.DnsEndpointType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.DnsEndpointType): DnsEndpointType = DnsEndpointType.values().first { it.javaValue == javaType }
    }
}
