@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication protocol that is used for the file share. Can only be specified when creating a share.
 */
public enum class EnabledProtocols(
    public val javaValue: com.pulumi.azurenative.storage.enums.EnabledProtocols,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.EnabledProtocols> {
    SMB(com.pulumi.azurenative.storage.enums.EnabledProtocols.SMB),
    NFS(com.pulumi.azurenative.storage.enums.EnabledProtocols.NFS),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.EnabledProtocols = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.EnabledProtocols): EnabledProtocols = EnabledProtocols.values().first { it.javaValue == javaType }
    }
}
