@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
 */
public enum class EncryptionScopeSource(
    public val javaValue: com.pulumi.azurenative.storage.enums.EncryptionScopeSource,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.EncryptionScopeSource> {
    Microsoft_Storage(com.pulumi.azurenative.storage.enums.EncryptionScopeSource.Microsoft_Storage),
    Microsoft_KeyVault(com.pulumi.azurenative.storage.enums.EncryptionScopeSource.Microsoft_KeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.EncryptionScopeSource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.EncryptionScopeSource): EncryptionScopeSource = EncryptionScopeSource.values().first { it.javaValue == javaType }
    }
}
