@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This is a required field, it specifies the format for the inventory files.
 */
public enum class Format(
    public val javaValue: com.pulumi.azurenative.storage.enums.Format,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Format> {
    Csv(com.pulumi.azurenative.storage.enums.Format.Csv),
    Parquet(com.pulumi.azurenative.storage.enums.Format.Parquet),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Format = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Format): Format =
            Format.values().first { it.javaValue == javaType }
    }
}
