@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 */
public enum class IntervalUnit(
    public val javaValue: com.pulumi.azurenative.storage.enums.IntervalUnit,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.IntervalUnit> {
    Days(com.pulumi.azurenative.storage.enums.IntervalUnit.Days),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.IntervalUnit = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.IntervalUnit): IntervalUnit =
            IntervalUnit.values().first { it.javaValue == javaType }
    }
}
