@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
 */
public enum class LargeFileSharesState(
    public val javaValue: com.pulumi.azurenative.storage.enums.LargeFileSharesState,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.LargeFileSharesState> {
    Disabled(com.pulumi.azurenative.storage.enums.LargeFileSharesState.Disabled),
    Enabled(com.pulumi.azurenative.storage.enums.LargeFileSharesState.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.LargeFileSharesState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.LargeFileSharesState): LargeFileSharesState = LargeFileSharesState.values().first { it.javaValue == javaType }
    }
}
