@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
 */
public enum class MinimumTlsVersion(
    public val javaValue: com.pulumi.azurenative.storage.enums.MinimumTlsVersion,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.MinimumTlsVersion> {
    TLS1_0(com.pulumi.azurenative.storage.enums.MinimumTlsVersion.TLS1_0),
    TLS1_1(com.pulumi.azurenative.storage.enums.MinimumTlsVersion.TLS1_1),
    TLS1_2(com.pulumi.azurenative.storage.enums.MinimumTlsVersion.TLS1_2),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.MinimumTlsVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.MinimumTlsVersion): MinimumTlsVersion = MinimumTlsVersion.values().first { it.javaValue == javaType }
    }
}
