@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
 */
public enum class Permissions(
    public val javaValue: com.pulumi.azurenative.storage.enums.Permissions,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Permissions> {
    R(com.pulumi.azurenative.storage.enums.Permissions.R),
    D(com.pulumi.azurenative.storage.enums.Permissions.D),
    W(com.pulumi.azurenative.storage.enums.Permissions.W),
    L(com.pulumi.azurenative.storage.enums.Permissions.L),
    A(com.pulumi.azurenative.storage.enums.Permissions.A),
    C(com.pulumi.azurenative.storage.enums.Permissions.C),
    U(com.pulumi.azurenative.storage.enums.Permissions.U),
    P(com.pulumi.azurenative.storage.enums.Permissions.P),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Permissions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Permissions): Permissions =
            Permissions.values().first { it.javaValue == javaType }
    }
}
