@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.PrivateEndpointServiceConnectionStatus): PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
