@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Routing Choice defines the kind of network routing opted by the user.
 */
public enum class RoutingChoice(
    public val javaValue: com.pulumi.azurenative.storage.enums.RoutingChoice,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.RoutingChoice> {
    MicrosoftRouting(com.pulumi.azurenative.storage.enums.RoutingChoice.MicrosoftRouting),
    InternetRouting(com.pulumi.azurenative.storage.enums.RoutingChoice.InternetRouting),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.RoutingChoice = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.RoutingChoice): RoutingChoice = RoutingChoice.values().first { it.javaValue == javaType }
    }
}
