@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
 */
public enum class ShareAccessTier(
    public val javaValue: com.pulumi.azurenative.storage.enums.ShareAccessTier,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.ShareAccessTier> {
    TransactionOptimized(com.pulumi.azurenative.storage.enums.ShareAccessTier.TransactionOptimized),
    Hot(com.pulumi.azurenative.storage.enums.ShareAccessTier.Hot),
    Cool(com.pulumi.azurenative.storage.enums.ShareAccessTier.Cool),
    Premium(com.pulumi.azurenative.storage.enums.ShareAccessTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.ShareAccessTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.ShareAccessTier): ShareAccessTier = ShareAccessTier.values().first { it.javaValue == javaType }
    }
}
