@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
 */
public enum class SignedResourceTypes(
    public val javaValue: com.pulumi.azurenative.storage.enums.SignedResourceTypes,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.SignedResourceTypes> {
    S(com.pulumi.azurenative.storage.enums.SignedResourceTypes.S),
    C(com.pulumi.azurenative.storage.enums.SignedResourceTypes.C),
    O(com.pulumi.azurenative.storage.enums.SignedResourceTypes.O),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.SignedResourceTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.SignedResourceTypes): SignedResourceTypes = SignedResourceTypes.values().first { it.javaValue == javaType }
    }
}
