@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.storage.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.SkuName> {
    Standard_LRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_LRS),
    Standard_GRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_GRS),
    Standard_RAGRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_RAGRS),
    Standard_ZRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_ZRS),
    Premium_LRS(com.pulumi.azurenative.storage.enums.SkuName.Premium_LRS),
    Premium_ZRS(com.pulumi.azurenative.storage.enums.SkuName.Premium_ZRS),
    Standard_GZRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_GZRS),
    Standard_RAGZRS(com.pulumi.azurenative.storage.enums.SkuName.Standard_RAGZRS),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
