@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The trigger type of the storage task assignment execution
 */
public enum class TriggerType(
    public val javaValue: com.pulumi.azurenative.storage.enums.TriggerType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.TriggerType> {
    RunOnce(com.pulumi.azurenative.storage.enums.TriggerType.RunOnce),
    OnSchedule(com.pulumi.azurenative.storage.enums.TriggerType.OnSchedule),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.TriggerType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.TriggerType): TriggerType =
            TriggerType.values().first { it.javaValue == javaType }
    }
}
