@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.AccountImmutabilityPolicyState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This defines account-level immutability policy properties.
 * @property allowProtectedAppendWrites This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property state The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
 */
public data class AccountImmutabilityPolicyPropertiesArgs(
    public val allowProtectedAppendWrites: Output<Boolean>? = null,
    public val immutabilityPeriodSinceCreationInDays: Output<Int>? = null,
    public val state: Output<Either<String, AccountImmutabilityPolicyState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs.builder()
            .allowProtectedAppendWrites(allowProtectedAppendWrites?.applyValue({ args0 -> args0 }))
            .immutabilityPeriodSinceCreationInDays(
                immutabilityPeriodSinceCreationInDays?.applyValue({ args0 ->
                    args0
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountImmutabilityPolicyPropertiesArgs].
 */
@PulumiTagMarker
public class AccountImmutabilityPolicyPropertiesArgsBuilder internal constructor() {
    private var allowProtectedAppendWrites: Output<Boolean>? = null

    private var immutabilityPeriodSinceCreationInDays: Output<Int>? = null

    private var state: Output<Either<String, AccountImmutabilityPolicyState>>? = null

    /**
     * @param value This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
     */
    @JvmName("gmaxjhwhxruvbnao")
    public suspend fun allowProtectedAppendWrites(`value`: Output<Boolean>) {
        this.allowProtectedAppendWrites = value
    }

    /**
     * @param value The immutability period for the blobs in the container since the policy creation, in days.
     */
    @JvmName("cqfxognghexeaxkj")
    public suspend fun immutabilityPeriodSinceCreationInDays(`value`: Output<Int>) {
        this.immutabilityPeriodSinceCreationInDays = value
    }

    /**
     * @param value The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
     */
    @JvmName("nhgbrgoefgnqbhiy")
    public suspend fun state(`value`: Output<Either<String, AccountImmutabilityPolicyState>>) {
        this.state = value
    }

    /**
     * @param value This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
     */
    @JvmName("olbkpmtfwxmpkiag")
    public suspend fun allowProtectedAppendWrites(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowProtectedAppendWrites = mapped
    }

    /**
     * @param value The immutability period for the blobs in the container since the policy creation, in days.
     */
    @JvmName("qcbrigpcqxugjlba")
    public suspend fun immutabilityPeriodSinceCreationInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutabilityPeriodSinceCreationInDays = mapped
    }

    /**
     * @param value The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
     */
    @JvmName("easomgmtswwlkmnl")
    public suspend fun state(`value`: Either<String, AccountImmutabilityPolicyState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
     */
    @JvmName("lbmjgdkecxqdwynl")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountImmutabilityPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
     */
    @JvmName("tifjoimmderndfto")
    public fun state(`value`: AccountImmutabilityPolicyState) {
        val toBeMapped = Either.ofRight<String, AccountImmutabilityPolicyState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): AccountImmutabilityPolicyPropertiesArgs =
        AccountImmutabilityPolicyPropertiesArgs(
            allowProtectedAppendWrites = allowProtectedAppendWrites,
            immutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays,
            state = state,
        )
}
