@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.InventoryRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The storage account blob inventory policy rules.
 * @property enabled Policy is enabled if set to true.
 * @property rules The storage account blob inventory policy rules. The rule is applied when it is enabled.
 * @property type The valid value is Inventory
 */
public data class BlobInventoryPolicySchemaArgs(
    public val enabled: Output<Boolean>,
    public val rules: Output<List<BlobInventoryPolicyRuleArgs>>,
    public val type: Output<Either<String, InventoryRuleType>>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs =
        com.pulumi.azurenative.storage.inputs.BlobInventoryPolicySchemaArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .rules(rules.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BlobInventoryPolicySchemaArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicySchemaArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var rules: Output<List<BlobInventoryPolicyRuleArgs>>? = null

    private var type: Output<Either<String, InventoryRuleType>>? = null

    /**
     * @param value Policy is enabled if set to true.
     */
    @JvmName("urhyyudnixvwehlr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("smojidgohnmjykwu")
    public suspend fun rules(`value`: Output<List<BlobInventoryPolicyRuleArgs>>) {
        this.rules = value
    }

    @JvmName("jgxkbwvacnbqignl")
    public suspend fun rules(vararg values: Output<BlobInventoryPolicyRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("rftqjfuitosghgln")
    public suspend fun rules(values: List<Output<BlobInventoryPolicyRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The valid value is Inventory
     */
    @JvmName("vvnwehuxrcfpjbcc")
    public suspend fun type(`value`: Output<Either<String, InventoryRuleType>>) {
        this.type = value
    }

    /**
     * @param value Policy is enabled if set to true.
     */
    @JvmName("jvjkgekjtiycvgyp")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("yuyspeldoohpyfny")
    public suspend fun rules(`value`: List<BlobInventoryPolicyRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("qbuuamjjxwarwelg")
    public suspend fun rules(argument: List<suspend BlobInventoryPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BlobInventoryPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("uiuqjlnyfydocauu")
    public suspend fun rules(vararg argument: suspend BlobInventoryPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BlobInventoryPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("pihsrclduihktvcn")
    public suspend fun rules(argument: suspend BlobInventoryPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BlobInventoryPolicyRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The storage account blob inventory policy rules. The rule is applied when it is enabled.
     */
    @JvmName("mdpadstjqetmthew")
    public suspend fun rules(vararg values: BlobInventoryPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value The valid value is Inventory
     */
    @JvmName("pfvitphanerchkyl")
    public suspend fun type(`value`: Either<String, InventoryRuleType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The valid value is Inventory
     */
    @JvmName("kigncjxovsrbrnmd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InventoryRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The valid value is Inventory
     */
    @JvmName("uwslykvocwyqxwwa")
    public fun type(`value`: InventoryRuleType) {
        val toBeMapped = Either.ofRight<String, InventoryRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobInventoryPolicySchemaArgs = BlobInventoryPolicySchemaArgs(
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        rules = rules ?: throw PulumiNullFieldException("rules"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
