@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.CustomDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The custom domain assigned to this storage account. This can be set via Update.
 * @property name Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
 * @property useSubDomainName Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
 */
public data class CustomDomainArgs(
    public val name: Output<String>,
    public val useSubDomainName: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.CustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.CustomDomainArgs =
        com.pulumi.azurenative.storage.inputs.CustomDomainArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .useSubDomainName(useSubDomainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainArgs].
 */
@PulumiTagMarker
public class CustomDomainArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var useSubDomainName: Output<Boolean>? = null

    /**
     * @param value Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
     */
    @JvmName("osnalsxaeidosopw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
     */
    @JvmName("hhvmirvburhfkbsa")
    public suspend fun useSubDomainName(`value`: Output<Boolean>) {
        this.useSubDomainName = value
    }

    /**
     * @param value Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
     */
    @JvmName("nrlttmoxafpreneh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
     */
    @JvmName("rifuobmtwfklloks")
    public suspend fun useSubDomainName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSubDomainName = mapped
    }

    internal fun build(): CustomDomainArgs = CustomDomainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        useSubDomainName = useSubDomainName,
    )
}
