@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Target helps provide filter parameters for the objects in the storage account and forms the execution context for the storage task
 * @property excludePrefix List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
 * @property prefix Required list of object prefixes to be included for task execution
 */
public data class ExecutionTargetArgs(
    public val excludePrefix: Output<List<String>>? = null,
    public val prefix: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs =
        com.pulumi.azurenative.storage.inputs.ExecutionTargetArgs.builder()
            .excludePrefix(excludePrefix?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefix(prefix.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ExecutionTargetArgs].
 */
@PulumiTagMarker
public class ExecutionTargetArgsBuilder internal constructor() {
    private var excludePrefix: Output<List<String>>? = null

    private var prefix: Output<List<String>>? = null

    /**
     * @param value List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
     */
    @JvmName("wjqlcgbjhbfyesqr")
    public suspend fun excludePrefix(`value`: Output<List<String>>) {
        this.excludePrefix = value
    }

    @JvmName("etcghmjsyqsoqrbk")
    public suspend fun excludePrefix(vararg values: Output<String>) {
        this.excludePrefix = Output.all(values.asList())
    }

    /**
     * @param values List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
     */
    @JvmName("cwjahdmfpfpuriei")
    public suspend fun excludePrefix(values: List<Output<String>>) {
        this.excludePrefix = Output.all(values)
    }

    /**
     * @param value Required list of object prefixes to be included for task execution
     */
    @JvmName("ebupepdlsxgmdebo")
    public suspend fun prefix(`value`: Output<List<String>>) {
        this.prefix = value
    }

    @JvmName("wnwdjpwjwegwloem")
    public suspend fun prefix(vararg values: Output<String>) {
        this.prefix = Output.all(values.asList())
    }

    /**
     * @param values Required list of object prefixes to be included for task execution
     */
    @JvmName("meyspyttxjbhaliy")
    public suspend fun prefix(values: List<Output<String>>) {
        this.prefix = Output.all(values)
    }

    /**
     * @param value List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
     */
    @JvmName("lgcccixnskoftxmg")
    public suspend fun excludePrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludePrefix = mapped
    }

    /**
     * @param values List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor
     */
    @JvmName("fgndohmslexbcuht")
    public suspend fun excludePrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludePrefix = mapped
    }

    /**
     * @param value Required list of object prefixes to be included for task execution
     */
    @JvmName("iprtmebyfcgejual")
    public suspend fun prefix(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param values Required list of object prefixes to be included for task execution
     */
    @JvmName("loyabigxunettjti")
    public suspend fun prefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ExecutionTargetArgs = ExecutionTargetArgs(
        excludePrefix = excludePrefix,
        prefix = prefix ?: throw PulumiNullFieldException("prefix"),
    )
}
